/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.cluster.internal;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.kuujo.copycat.cluster.LocalMember;
import net.kuujo.copycat.cluster.MessageHandler;
import net.kuujo.copycat.cluster.internal.CoordinatedMember;
import net.kuujo.copycat.cluster.internal.MemberInfo;
import net.kuujo.copycat.cluster.internal.coordinator.LocalMemberCoordinator;
import net.kuujo.copycat.cluster.internal.manager.LocalMemberManager;
import net.kuujo.copycat.util.serializer.Serializer;

public class CoordinatedLocalMember
extends CoordinatedMember
implements LocalMemberManager {
    private final LocalMemberCoordinator coordinator;
    private volatile boolean open;

    public CoordinatedLocalMember(int id, MemberInfo info, LocalMemberCoordinator coordinator, Serializer serializer, Executor executor) {
        super(id, info, coordinator, serializer, executor);
        this.coordinator = coordinator;
    }

    private <T, U> MessageHandler<ByteBuffer, ByteBuffer> wrapHandler(MessageHandler<T, U> handler, Serializer serializer, Executor executor) {
        return message -> {
            CompletableFuture future = new CompletableFuture();
            executor.execute(() -> ((CompletableFuture)handler.apply(serializer.readObject((ByteBuffer)message))).whenComplete((result, error) -> {
                if (error == null) {
                    future.complete(serializer.writeObject(result));
                } else {
                    future.completeExceptionally((Throwable)error);
                }
            }));
            return future;
        };
    }

    @Override
    public <T, U> LocalMemberManager registerHandler(String topic, int id, MessageHandler<T, U> handler, Serializer serializer, Executor executor) {
        this.coordinator.register(topic, this.id, id, this.wrapHandler(handler, serializer, executor));
        return this;
    }

    @Override
    public LocalMemberManager unregisterHandler(String topic, int id) {
        this.coordinator.unregister(topic, this.id, id);
        return this;
    }

    @Override
    public <T, U> LocalMember registerHandler(String topic, MessageHandler<T, U> handler) {
        return this.registerHandler(topic, 0, handler, this.serializer, this.executor);
    }

    @Override
    public LocalMember unregisterHandler(String topic) {
        return this.unregisterHandler(topic, 0);
    }

    @Override
    public CompletableFuture<LocalMemberManager> open() {
        this.open = true;
        this.registerHandler("execute", -1, task -> CompletableFuture.completedFuture(task.execute()), this.serializer, this.executor);
        return CompletableFuture.completedFuture(this);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public CompletableFuture<Void> close() {
        this.open = false;
        this.unregisterHandler("execute", -1);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }
}

