/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.cluster.internal;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.kuujo.copycat.Task;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.cluster.internal.MemberInfo;
import net.kuujo.copycat.cluster.internal.coordinator.MemberCoordinator;
import net.kuujo.copycat.cluster.internal.manager.MemberManager;
import net.kuujo.copycat.util.serializer.Serializer;

public class CoordinatedMember
implements MemberManager {
    protected static final String EXECUTE_TOPIC = "execute";
    protected static final int USER_ID = 0;
    protected static final int EXECUTE_ID = -1;
    protected final int id;
    private final MemberInfo info;
    private final MemberCoordinator coordinator;
    protected final Serializer serializer;
    protected final Executor executor;

    public CoordinatedMember(int id, MemberInfo info, MemberCoordinator coordinator, Serializer serializer, Executor executor) {
        this.id = id;
        this.info = info;
        this.coordinator = coordinator;
        this.serializer = serializer;
        this.executor = executor;
    }

    MemberInfo info() {
        return this.info;
    }

    public MemberCoordinator coordinator() {
        return this.coordinator;
    }

    @Override
    public String uri() {
        return this.info.uri();
    }

    @Override
    public Member.Type type() {
        return this.info.type();
    }

    @Override
    public Member.Status state() {
        return this.info.state();
    }

    @Override
    public <T, U> CompletableFuture<U> send(String topic, T message) {
        return this.send(topic, 0, message, this.serializer, this.executor);
    }

    @Override
    public <T, U> CompletableFuture<U> send(String topic, int id, T message, Serializer serializer, Executor executor) {
        return this.coordinator.send(topic, this.id, id, serializer.writeObject(message)).thenApplyAsync(serializer::readObject, executor);
    }

    @Override
    public CompletableFuture<Void> execute(Task<Void> task) {
        return this.send(EXECUTE_TOPIC, -1, task, this.serializer, this.executor);
    }

    @Override
    public <T> CompletableFuture<T> submit(Task<T> task) {
        return this.send(EXECUTE_TOPIC, -1, task, this.serializer, this.executor);
    }

    public String toString() {
        return String.format("%s[uri=%s]", this.getClass().getCanonicalName(), this.coordinator.uri());
    }
}

