/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.cluster.internal.coordinator;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.kuujo.copycat.cluster.ClusterException;
import net.kuujo.copycat.cluster.internal.AbstractCluster;
import net.kuujo.copycat.cluster.internal.CoordinatedMember;
import net.kuujo.copycat.cluster.internal.MemberInfo;
import net.kuujo.copycat.cluster.internal.Router;
import net.kuujo.copycat.cluster.internal.coordinator.AbstractMemberCoordinator;
import net.kuujo.copycat.cluster.internal.coordinator.ClusterCoordinator;
import net.kuujo.copycat.cluster.internal.coordinator.DefaultRemoteMemberCoordinator;
import net.kuujo.copycat.raft.RaftContext;
import net.kuujo.copycat.util.concurrent.NamedThreadFactory;
import net.kuujo.copycat.util.serializer.Serializer;

public class CoordinatorCluster
extends AbstractCluster {
    public CoordinatorCluster(int id, ClusterCoordinator coordinator, RaftContext context, Router router, Serializer serializer, ScheduledExecutorService executor, Executor userExecutor) {
        super(id, coordinator, context, router, serializer, executor, userExecutor);
    }

    @Override
    protected CoordinatedMember createMember(MemberInfo info) {
        DefaultRemoteMemberCoordinator memberCoordinator = new DefaultRemoteMemberCoordinator(info, this.coordinator.config().getClusterConfig().getProtocol(), Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory(String.format("copycat-coordinator-%s", info.uri()))));
        try {
            ((AbstractMemberCoordinator)memberCoordinator).open().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ClusterException(e);
        }
        return new CoordinatedMember(this.id, info, memberCoordinator, this.serializer, this.executor);
    }
}

