/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.cluster.internal.coordinator;

import com.typesafe.config.ConfigValueFactory;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.util.AbstractConfigurable;
import net.kuujo.copycat.util.Configurable;
import net.kuujo.copycat.util.concurrent.NamedThreadFactory;
import net.kuujo.copycat.util.internal.Assert;

public class CoordinatorConfig
extends AbstractConfigurable {
    public static final String COORDINATOR_NAME = "name";
    public static final String COORDINATOR_CLUSTER = "cluster";
    public static final String COORDINATOR_EXECUTOR = "executor";
    private final Executor DEFAULT_COORDINATOR_EXECUTOR = Executors.newSingleThreadExecutor(new NamedThreadFactory("copycat-coordinator-%d"));
    private ClusterConfig clusterConfig;
    private Executor executor;

    public CoordinatorConfig() {
    }

    public CoordinatorConfig(CoordinatorConfig config) {
        super(config);
    }

    public CoordinatorConfig(Map<String, Object> config) {
        super(config, new String[0]);
    }

    @Override
    public CoordinatorConfig copy() {
        return new CoordinatorConfig(this);
    }

    public void setName(String name) {
        this.config = this.config.withValue(COORDINATOR_NAME, ConfigValueFactory.fromAnyRef(Assert.isNotNull(name, COORDINATOR_NAME)));
    }

    public String getName() {
        return this.config.getString(COORDINATOR_NAME);
    }

    public CoordinatorConfig withName(String name) {
        this.setName(name);
        return this;
    }

    public void setClusterConfig(ClusterConfig cluster) {
        this.config = this.config.withValue(COORDINATOR_CLUSTER, ConfigValueFactory.fromMap(Assert.isNotNull(cluster, "config").toMap()));
        this.clusterConfig = cluster;
    }

    public ClusterConfig getClusterConfig() {
        return this.clusterConfig != null ? this.clusterConfig : (ClusterConfig)Configurable.load(this.config.getObject(COORDINATOR_CLUSTER).unwrapped());
    }

    public CoordinatorConfig withClusterConfig(ClusterConfig config) {
        this.setClusterConfig(config);
        return this;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor != null ? this.executor : this.DEFAULT_COORDINATOR_EXECUTOR;
    }

    public CoordinatorConfig withExecutor(Executor executor) {
        this.setExecutor(executor);
        return this;
    }
}

