/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.collections;

import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatorConfig;
import net.kuujo.copycat.cluster.internal.coordinator.DefaultClusterCoordinator;
import net.kuujo.copycat.collections.AsyncMultiMapConfig;
import net.kuujo.copycat.collections.AsyncMultiMapProxy;
import net.kuujo.copycat.resource.Resource;

public interface AsyncMultiMap<K, V>
extends AsyncMultiMapProxy<K, V>,
Resource<AsyncMultiMap<K, V>> {
    public static <K, V> AsyncMultiMap<K, V> create(String name) {
        return AsyncMultiMap.create(name, new ClusterConfig(String.format("%s-cluster", name)), new AsyncMultiMapConfig(name));
    }

    public static <K, V> AsyncMultiMap<K, V> create(String name, ClusterConfig cluster) {
        return AsyncMultiMap.create(name, cluster, new AsyncMultiMapConfig(name));
    }

    public static <K, V> AsyncMultiMap<K, V> create(String name, ClusterConfig cluster, AsyncMultiMapConfig config) {
        DefaultClusterCoordinator coordinator = new DefaultClusterCoordinator(new CoordinatorConfig().withName(name).withClusterConfig(cluster));
        return (AsyncMultiMap)((AsyncMultiMap)((AsyncMultiMap)coordinator.getResource(name, config.resolve(cluster))).addStartupTask(() -> coordinator.open().thenApply(v -> null))).addShutdownTask(coordinator::close);
    }
}

