/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.collections;

import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatorConfig;
import net.kuujo.copycat.cluster.internal.coordinator.DefaultClusterCoordinator;
import net.kuujo.copycat.collections.AsyncCollection;
import net.kuujo.copycat.collections.AsyncSetConfig;
import net.kuujo.copycat.collections.AsyncSetProxy;

public interface AsyncSet<T>
extends AsyncCollection<AsyncSet<T>, T>,
AsyncSetProxy<T> {
    public static <T> AsyncSet<T> create(String name) {
        return AsyncSet.create(name, new ClusterConfig(String.format("%s-cluster", name)), new AsyncSetConfig(name));
    }

    public static <T> AsyncSet<T> create(String name, ClusterConfig cluster) {
        return AsyncSet.create(name, cluster, new AsyncSetConfig(name));
    }

    public static <T> AsyncSet<T> create(String name, ClusterConfig cluster, AsyncSetConfig config) {
        DefaultClusterCoordinator coordinator = new DefaultClusterCoordinator(new CoordinatorConfig().withName(name).withClusterConfig(cluster));
        return (AsyncSet)((AsyncSet)((AsyncSet)coordinator.getResource(name, config.resolve(cluster))).addStartupTask(() -> coordinator.open().thenApply(v -> null))).addShutdownTask(coordinator::close);
    }
}

