/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.event;

import com.typesafe.config.ConfigValueFactory;
import java.util.Map;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatedResourceConfig;
import net.kuujo.copycat.event.internal.DefaultEventLog;
import net.kuujo.copycat.event.retention.RetentionPolicy;
import net.kuujo.copycat.resource.ResourceConfig;
import net.kuujo.copycat.util.Configurable;
import net.kuujo.copycat.util.internal.Assert;

public class EventLogConfig
extends ResourceConfig<EventLogConfig> {
    private static final String EVENT_LOG_RETENTION_POLICY = "retention.policy";
    private static final String EVENT_LOG_RETENTION_CHECK_INTERVAL = "retention.check.interval";
    private static final String DEFAULT_CONFIGURATION = "event-log-defaults";
    private static final String CONFIGURATION = "event-log";

    public EventLogConfig() {
        super(CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    public EventLogConfig(Map<String, Object> config) {
        super(config, CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    public EventLogConfig(String resource) {
        super(resource, CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    private EventLogConfig(EventLogConfig config) {
        super(config);
    }

    @Override
    public EventLogConfig copy() {
        return new EventLogConfig(this);
    }

    public void setRetentionCheckInterval(long interval) {
        this.config = this.config.withValue(EVENT_LOG_RETENTION_CHECK_INTERVAL, ConfigValueFactory.fromAnyRef(Assert.arg(interval, interval > 0L, "Compact interval must be positive", new Object[0])));
    }

    public long getRetentionCheckInterval() {
        return this.config.getLong(EVENT_LOG_RETENTION_CHECK_INTERVAL);
    }

    public EventLogConfig withRetentionCheckInterval(long interval) {
        this.setRetentionCheckInterval(interval);
        return this;
    }

    public void setRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.config = this.config.withValue(EVENT_LOG_RETENTION_POLICY, ConfigValueFactory.fromAnyRef(Assert.isNotNull(retentionPolicy, "retentionPolicy")));
    }

    public RetentionPolicy getRetentionPolicy() {
        return (RetentionPolicy)Configurable.load(this.config.getObject(EVENT_LOG_RETENTION_POLICY).unwrapped());
    }

    public EventLogConfig withRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.setRetentionPolicy(retentionPolicy);
        return this;
    }

    @Override
    public CoordinatedResourceConfig resolve(ClusterConfig cluster) {
        Assert.config(this.getReplicas(), this.getReplicas().isEmpty() || cluster.getMembers().containsAll(this.getReplicas()), "Resource replica set must contain only active cluster members", new Object[0]);
        return new CoordinatedResourceConfig(super.toMap()).withElectionTimeout(this.getElectionTimeout()).withHeartbeatInterval(this.getHeartbeatInterval()).withResourceType(DefaultEventLog.class).withLog(this.getLog()).withSerializer(this.getSerializer()).withExecutor(this.getExecutor()).withResourceConfig(this).withReplicas(this.getReplicas().isEmpty() ? cluster.getMembers() : this.getReplicas());
    }
}

