/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.log;

import java.nio.ByteBuffer;
import java.util.TreeMap;
import net.kuujo.copycat.log.AbstractLogSegment;
import net.kuujo.copycat.log.BufferedLogManager;
import net.kuujo.copycat.log.LogManager;
import net.kuujo.copycat.util.internal.Assert;

public class BufferedLogSegment
extends AbstractLogSegment {
    private final BufferedLogManager parent;
    private long timestamp;
    private TreeMap<Long, ByteBuffer> log;
    private int size;

    BufferedLogSegment(BufferedLogManager parent, long id, long firstIndex) {
        super(id, firstIndex);
        this.parent = parent;
    }

    @Override
    public LogManager log() {
        return this.parent;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public void open() {
        this.assertIsNotOpen();
        if (this.log == null) {
            this.log = new TreeMap();
            this.size = 0;
            this.timestamp = System.currentTimeMillis();
        }
    }

    @Override
    public boolean isOpen() {
        return this.log != null;
    }

    @Override
    public boolean isEmpty() {
        return this.log == null || this.log.isEmpty();
    }

    @Override
    public long size() {
        this.assertIsOpen();
        return this.size;
    }

    @Override
    public long entryCount() {
        this.assertIsOpen();
        return this.log.size();
    }

    @Override
    public long appendEntry(ByteBuffer entry) {
        Assert.isNotNull(entry, "entry");
        this.assertIsOpen();
        long index = this.log.isEmpty() ? this.firstIndex : this.log.lastKey() + 1L;
        this.log.put(index, entry);
        this.size += entry.limit();
        return index;
    }

    @Override
    public Long firstIndex() {
        this.assertIsOpen();
        return !this.log.isEmpty() ? this.log.firstKey() : null;
    }

    @Override
    public Long lastIndex() {
        this.assertIsOpen();
        return !this.log.isEmpty() ? this.log.lastKey() : null;
    }

    @Override
    public boolean containsIndex(long index) {
        this.assertIsOpen();
        return this.log.containsKey(index);
    }

    @Override
    public ByteBuffer getEntry(long index) {
        this.assertIsOpen();
        this.assertContainsIndex(index);
        ByteBuffer buffer = this.log.get(index);
        buffer.rewind();
        return buffer;
    }

    @Override
    public void removeAfter(long index) {
        this.assertIsOpen();
        if (index < this.firstIndex) {
            this.log.clear();
            this.size = 0;
        } else {
            this.assertContainsIndex(index);
            for (long i = index + 1L; i <= this.log.lastKey(); ++i) {
                ByteBuffer value = this.log.remove(i);
                if (value == null) continue;
                this.size -= value.limit();
            }
        }
    }

    @Override
    public void flush() {
        this.assertIsOpen();
    }

    @Override
    public void close() {
        this.assertIsOpen();
    }

    @Override
    public boolean isClosed() {
        return this.log == null;
    }

    @Override
    public void delete() {
        if (this.log != null) {
            this.log.clear();
            this.log = null;
        }
    }

    @Override
    public String toString() {
        return String.format("%s[firstIndex=%s, lastIndex=%s]", this.getClass().getSimpleName(), this.log != null && !this.log.isEmpty() ? this.log.firstKey() : null, this.log != null && !this.log.isEmpty() ? this.log.lastKey() : null);
    }
}

