/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.log;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.HashMap;
import net.kuujo.copycat.log.AbstractLogManager;
import net.kuujo.copycat.log.FileLog;
import net.kuujo.copycat.log.FileLogSegment;
import net.kuujo.copycat.log.LogException;
import net.kuujo.copycat.log.LogSegment;

public class FileLogManager
extends AbstractLogManager {
    final FileLog config;
    final File base;

    FileLogManager(String name, FileLog config) {
        super(config);
        this.config = config.copy();
        this.base = new File(config.getDirectory(), name);
    }

    @Override
    protected Collection<LogSegment> loadSegments() {
        HashMap<Long, FileLogSegment> segments = new HashMap<Long, FileLogSegment>();
        this.base.getAbsoluteFile().getParentFile().mkdirs();
        for (File file : this.config.getDirectory().listFiles(File::isFile)) {
            if (!file.getName().startsWith(this.base.getName() + "-") || !file.getName().endsWith(".metadata")) continue;
            try {
                long id = Long.valueOf(file.getName().substring(file.getName().lastIndexOf(45) + 1, file.getName().lastIndexOf(46)));
                if (segments.containsKey(id)) continue;
                try (RandomAccessFile metaFile = new RandomAccessFile(file, "r");){
                    long firstIndex = metaFile.readLong();
                    segments.put(id, new FileLogSegment(this, id, firstIndex));
                }
            }
            catch (IOException | NumberFormatException e) {
                throw new LogException(e);
            }
        }
        return segments.values();
    }

    @Override
    protected LogSegment createSegment(long segmentId, long firstIndex) {
        return new FileLogSegment(this, segmentId, firstIndex);
    }
}

