/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.log;

import com.typesafe.config.ConfigValueFactory;
import java.util.Map;
import net.kuujo.copycat.util.AbstractConfigurable;
import net.kuujo.copycat.util.Configurable;
import net.kuujo.copycat.util.internal.Assert;

public abstract class LogConfig
extends AbstractConfigurable
implements Configurable {
    private static final String LOG_SEGMENT_SIZE = "segment.size";
    private static final String LOG_SEGMENT_INTERVAL = "segment.interval";
    private static final String LOG_FLUSH_ON_WRITE = "flush.on-write";
    private static final String LOG_FLUSH_INTERVAL = "flush.interval";
    private static final String DEFAULT_CONFIGURATION = "log-defaults";
    private static final String CONFIGURATION = "log";

    protected LogConfig() {
        super(CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    protected LogConfig(Map<String, Object> config, String ... resources) {
        super(config, LogConfig.addResources(resources, CONFIGURATION, DEFAULT_CONFIGURATION));
    }

    protected LogConfig(LogConfig log) {
        super(log);
    }

    protected LogConfig(String ... resources) {
        super(LogConfig.addResources(resources, CONFIGURATION, DEFAULT_CONFIGURATION));
    }

    @Override
    public LogConfig copy() {
        return (LogConfig)super.copy();
    }

    public void setSegmentSize(int segmentSize) {
        this.config = this.config.withValue(LOG_SEGMENT_SIZE, ConfigValueFactory.fromAnyRef(Assert.arg(segmentSize, segmentSize > 0, "segment size must be positive", new Object[0])));
    }

    public int getSegmentSize() {
        return this.config.getInt(LOG_SEGMENT_SIZE);
    }

    public LogConfig withSegmentSize(int segmentSize) {
        this.setSegmentSize(segmentSize);
        return this;
    }

    public void setSegmentInterval(long segmentInterval) {
        this.config = this.config.withValue(LOG_SEGMENT_INTERVAL, ConfigValueFactory.fromAnyRef(Assert.arg(segmentInterval, segmentInterval > 0L, "segment interval must be positive", new Object[0])));
    }

    public long getSegmentInterval() {
        long interval = this.config.getLong(LOG_SEGMENT_INTERVAL);
        return interval > -1L ? interval : Long.MAX_VALUE;
    }

    public LogConfig withSegmentInterval(long segmentInterval) {
        this.setSegmentInterval(segmentInterval);
        return this;
    }

    public void setFlushOnWrite(boolean flushOnWrite) {
        this.config = this.config.withValue(LOG_FLUSH_ON_WRITE, ConfigValueFactory.fromAnyRef(flushOnWrite));
    }

    public boolean isFlushOnWrite() {
        return this.config.getBoolean(LOG_FLUSH_ON_WRITE);
    }

    public LogConfig withFlushOnWrite(boolean flushOnWrite) {
        this.setFlushOnWrite(flushOnWrite);
        return this;
    }

    public void setFlushInterval(long flushInterval) {
        this.config = this.config.withValue(LOG_FLUSH_INTERVAL, ConfigValueFactory.fromAnyRef(Assert.arg(flushInterval, flushInterval > 0L, "flush interval must be positive", new Object[0])));
    }

    public long getFlushInterval() {
        long interval = this.config.getLong(LOG_FLUSH_INTERVAL);
        return interval > -1L ? interval : Long.MAX_VALUE;
    }

    public LogConfig withFlushInterval(long flushInterval) {
        this.setFlushInterval(flushInterval);
        return this;
    }
}

