/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.protocol;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.kuujo.copycat.protocol.AbstractProtocol;
import net.kuujo.copycat.protocol.LocalProtocolClient;
import net.kuujo.copycat.protocol.LocalProtocolServer;
import net.kuujo.copycat.protocol.ProtocolClient;
import net.kuujo.copycat.protocol.ProtocolServer;

public class LocalProtocol
extends AbstractProtocol {
    private static Map<String, LocalProtocolServer> REGISTRY = new ConcurrentHashMap<String, LocalProtocolServer>(32);

    public static void reset() {
        REGISTRY = new ConcurrentHashMap<String, LocalProtocolServer>(32);
    }

    public LocalProtocol() {
    }

    public LocalProtocol(Map<String, Object> config) {
        super(config, new String[0]);
    }

    private LocalProtocol(LocalProtocol protocol) {
        super(protocol);
    }

    @Override
    public LocalProtocol copy() {
        return new LocalProtocol(this);
    }

    @Override
    public ProtocolClient createClient(URI uri) {
        return new LocalProtocolClient(uri.getAuthority(), REGISTRY);
    }

    @Override
    public ProtocolServer createServer(URI uri) {
        return new LocalProtocolServer(uri.getAuthority(), REGISTRY);
    }

    @Override
    public String toString() {
        return String.format("%s[registry=%s]", this.getClass().getSimpleName(), REGISTRY);
    }
}

