/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.protocol;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.kuujo.copycat.protocol.ProtocolException;
import net.kuujo.copycat.protocol.ProtocolHandler;
import net.kuujo.copycat.protocol.ProtocolServer;
import net.kuujo.copycat.util.concurrent.Futures;
import net.kuujo.copycat.util.concurrent.NamedThreadFactory;

public class LocalProtocolServer
implements ProtocolServer {
    private final Executor executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("copycat-protocol-thread-%d"));
    private final String address;
    private final Map<String, LocalProtocolServer> registry;
    private ProtocolHandler handler;

    public LocalProtocolServer(String address, Map<String, LocalProtocolServer> registry) {
        this.address = address;
        this.registry = registry;
    }

    @Override
    public void handler(ProtocolHandler handler) {
        this.handler = handler;
    }

    CompletableFuture<ByteBuffer> handle(ByteBuffer request) {
        if (this.handler == null) {
            return Futures.exceptionalFuture(new ProtocolException("No protocol handler registered", new Object[0]));
        }
        return CompletableFuture.supplyAsync(() -> this.handler, this.executor).thenComposeAsync(handler -> (CompletableFuture)handler.apply(request));
    }

    @Override
    public CompletableFuture<Void> listen() {
        return CompletableFuture.supplyAsync(() -> {
            this.registry.put(this.address, this);
            return null;
        }, this.executor);
    }

    @Override
    public CompletableFuture<Void> close() {
        return CompletableFuture.supplyAsync(() -> {
            this.registry.remove(this.address);
            return null;
        }, this.executor);
    }
}

