/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft;

import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kuujo.copycat.raft.ActiveState;
import net.kuujo.copycat.raft.RaftContext;
import net.kuujo.copycat.raft.RaftState;
import net.kuujo.copycat.raft.protocol.AppendRequest;
import net.kuujo.copycat.raft.protocol.AppendResponse;
import net.kuujo.copycat.raft.protocol.PollRequest;
import net.kuujo.copycat.raft.protocol.VoteRequest;
import net.kuujo.copycat.raft.protocol.VoteResponse;
import net.kuujo.copycat.util.internal.Quorum;

class FollowerState
extends ActiveState {
    private final Random random = new Random();
    private ScheduledFuture<?> currentTimer;

    public FollowerState(RaftContext context) {
        super(context);
    }

    @Override
    public RaftState.Type type() {
        return RaftState.Type.FOLLOWER;
    }

    @Override
    public synchronized CompletableFuture<Void> open() {
        return super.open().thenRun(this::startHeartbeatTimeout);
    }

    private void startHeartbeatTimeout() {
        this.LOGGER.debug("{} - Starting heartbeat timer", (Object)this.context.getLocalMember());
        this.resetHeartbeatTimeout();
    }

    private void resetHeartbeatTimeout() {
        this.context.checkThread();
        if (this.isClosed()) {
            return;
        }
        if (this.currentTimer != null) {
            this.LOGGER.debug("{} - Reset heartbeat timeout", (Object)this.context.getLocalMember());
            this.currentTimer.cancel(false);
        }
        long delay = this.context.getElectionTimeout() + (long)this.random.nextInt((int)this.context.getElectionTimeout()) % this.context.getElectionTimeout();
        this.currentTimer = this.context.executor().schedule(() -> {
            this.currentTimer = null;
            if (this.isOpen()) {
                if (this.context.getLastVotedFor() == null) {
                    this.LOGGER.info("{} - Heartbeat timed out in {} milliseconds", (Object)this.context.getLocalMember(), (Object)delay);
                    this.sendPollRequests();
                } else {
                    this.resetHeartbeatTimeout();
                }
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    private void sendPollRequests() {
        this.currentTimer = this.context.executor().schedule(() -> {
            this.LOGGER.debug("{} - Failed to poll a majority of the cluster in {} milliseconds", (Object)this.context.getLocalMember(), (Object)this.context.getElectionTimeout());
            this.resetHeartbeatTimeout();
        }, this.context.getElectionTimeout(), TimeUnit.MILLISECONDS);
        AtomicBoolean complete = new AtomicBoolean();
        Quorum quorum = new Quorum(1 + (int)Math.floor((double)this.context.getActiveMembers().size() / 2.0), elected -> {
            complete.set(true);
            if (elected.booleanValue()) {
                this.transition(RaftState.Type.CANDIDATE);
            } else {
                this.resetHeartbeatTimeout();
            }
        });
        Long lastIndex = this.context.log().lastIndex();
        ByteBuffer lastEntry = lastIndex != null ? this.context.log().getEntry(lastIndex) : null;
        this.LOGGER.info("{} - Polling members {}", (Object)this.context.getLocalMember(), this.context.getActiveMembers());
        Long lastTerm = lastEntry != null ? Long.valueOf(lastEntry.getLong()) : null;
        for (String member : this.context.getActiveMembers()) {
            this.LOGGER.debug("{} - Polling {} for next term {}", new Object[]{this.context.getLocalMember(), member, this.context.getTerm() + 1L});
            PollRequest request = ((PollRequest.Builder)PollRequest.builder().withUri(member)).withTerm(this.context.getTerm()).withCandidate(this.context.getLocalMember()).withLogIndex(lastIndex).withLogTerm(lastTerm).build();
            ((CompletableFuture)this.pollHandler.apply(request)).whenCompleteAsync((response, error) -> {
                this.context.checkThread();
                if (this.isOpen() && !complete.get()) {
                    if (error != null) {
                        this.LOGGER.debug("{} - Failed to poll {}. Reason: {}", new Object[]{this.context.getLocalMember(), member, error.getMessage()});
                        quorum.fail();
                    } else {
                        if (response.term() > this.context.getTerm()) {
                            this.context.setTerm(response.term());
                        }
                        if (!response.accepted()) {
                            this.LOGGER.info("{} - Received rejected poll from {}", (Object)this.context.getLocalMember(), (Object)member);
                            quorum.fail();
                        } else if (response.term() != this.context.getTerm()) {
                            this.LOGGER.info("{} - Received accepted poll for a different term from {}", (Object)this.context.getLocalMember(), (Object)member);
                            quorum.fail();
                        } else {
                            this.LOGGER.info("{} - Received accepted poll from {}", (Object)this.context.getLocalMember(), (Object)member);
                            quorum.succeed();
                        }
                    }
                }
            }, (Executor)this.context.executor());
        }
    }

    @Override
    public CompletableFuture<AppendResponse> append(AppendRequest request) {
        this.resetHeartbeatTimeout();
        CompletableFuture<AppendResponse> response = super.append(request);
        this.resetHeartbeatTimeout();
        return response;
    }

    @Override
    protected VoteResponse handleVote(VoteRequest request) {
        VoteResponse response = super.handleVote(request);
        if (response.voted()) {
            this.resetHeartbeatTimeout();
        }
        return response;
    }

    private void cancelHeartbeatTimeout() {
        if (this.currentTimer != null) {
            this.LOGGER.debug("{} - Cancelling heartbeat timer", (Object)this.context.getLocalMember());
            this.currentTimer.cancel(false);
        }
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return super.close().thenRun(this::cancelHeartbeatTimeout);
    }
}

