/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft;

import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigValueFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.util.AbstractConfigurable;
import net.kuujo.copycat.util.Configurable;
import net.kuujo.copycat.util.internal.Assert;

public class RaftConfig
extends AbstractConfigurable {
    private static final String RESOURCE_ELECTION_TIMEOUT = "election.timeout";
    private static final String RESOURCE_HEARTBEAT_INTERVAL = "heartbeat.interval";
    private static final String RESOURCE_REPLICAS = "replicas";
    private static final String RESOURCE_LOG = "log";

    public RaftConfig() {
    }

    public RaftConfig(Map<String, Object> config) {
        super(config, new String[0]);
    }

    protected RaftConfig(RaftConfig config) {
        super(config);
    }

    @Override
    public RaftConfig copy() {
        return new RaftConfig(this);
    }

    public void setElectionTimeout(long electionTimeout) {
        this.config = this.config.withValue(RESOURCE_ELECTION_TIMEOUT, ConfigValueFactory.fromAnyRef(Assert.arg(electionTimeout, electionTimeout > 0L, "election timeout must be positive", new Object[0])));
    }

    public void setElectionTimeout(long electionTimeout, TimeUnit unit) {
        this.setElectionTimeout(unit.toMillis(electionTimeout));
    }

    public long getElectionTimeout() {
        return this.config.getLong(RESOURCE_ELECTION_TIMEOUT);
    }

    public RaftConfig withElectionTimeout(long electionTimeout) {
        this.setElectionTimeout(electionTimeout);
        return this;
    }

    public RaftConfig withElectionTimeout(long electionTimeout, TimeUnit unit) {
        this.setElectionTimeout(electionTimeout, unit);
        return this;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.config = this.config.withValue(RESOURCE_HEARTBEAT_INTERVAL, ConfigValueFactory.fromAnyRef(Assert.arg(heartbeatInterval, heartbeatInterval > 0L, "heartbeat interval must be positive", new Object[0])));
    }

    public void setHeartbeatInterval(long heartbeatInterval, TimeUnit unit) {
        this.setHeartbeatInterval(unit.toMillis(heartbeatInterval));
    }

    public long getHeartbeatInterval() {
        return this.config.getLong(RESOURCE_HEARTBEAT_INTERVAL);
    }

    public RaftConfig withHeartbeatInterval(long heartbeatInterval) {
        this.setHeartbeatInterval(heartbeatInterval);
        return this;
    }

    public RaftConfig withHeartbeatInterval(long heartbeatInterval, TimeUnit unit) {
        this.setHeartbeatInterval(heartbeatInterval, unit);
        return this;
    }

    public void setReplicas(String ... replicas) {
        this.setReplicas(Arrays.asList(replicas));
    }

    public void setReplicas(Collection<String> replicas) {
        this.config = this.config.withValue(RESOURCE_REPLICAS, ConfigValueFactory.fromIterable(new HashSet<String>(Assert.isNotNull(replicas, RESOURCE_REPLICAS))));
    }

    public Set<String> getReplicas() {
        return new HashSet<String>(this.config.hasPath(RESOURCE_REPLICAS) ? this.config.getList(RESOURCE_REPLICAS).unwrapped() : new ArrayList(0));
    }

    public RaftConfig withReplicas(String ... replicas) {
        this.setReplicas(Arrays.asList(replicas));
        return this;
    }

    public RaftConfig withReplicas(Collection<String> replicas) {
        this.setReplicas(replicas);
        return this;
    }

    public RaftConfig addReplica(String replica) {
        if (!this.config.hasPath(RESOURCE_REPLICAS)) {
            this.config = this.config.withValue(RESOURCE_REPLICAS, ConfigValueFactory.fromIterable(new ArrayList(1)));
        }
        ConfigList replicas = this.config.getList(RESOURCE_REPLICAS);
        replicas.add(ConfigValueFactory.fromAnyRef(Assert.isNotNull(replica, "replica")));
        return this;
    }

    public RaftConfig removeReplica(String replica) {
        ConfigList replicas = this.config.getList(RESOURCE_REPLICAS);
        replicas.remove(ConfigValueFactory.fromAnyRef(Assert.isNotNull(replica, "replica")));
        return this;
    }

    public RaftConfig clearReplicas() {
        this.config.withoutPath(RESOURCE_REPLICAS);
        return this;
    }

    public void setLog(Log log) {
        this.config = this.config.withValue(RESOURCE_LOG, ConfigValueFactory.fromMap(log.toMap()));
    }

    public Log getLog() {
        return (Log)Configurable.load(this.config.getObject(RESOURCE_LOG).unwrapped());
    }

    public RaftConfig withLog(Log log) {
        this.setLog(log);
        return this;
    }
}

