/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft.protocol;

import java.util.Objects;
import net.kuujo.copycat.raft.protocol.Request;
import net.kuujo.copycat.util.internal.Assert;

abstract class AbstractRequest
implements Request {
    protected String member;

    AbstractRequest() {
    }

    @Override
    public String uri() {
        return this.member;
    }

    public int hashCode() {
        return Objects.hash(this.member);
    }

    public String toString() {
        return String.format("%s[uri=%s]", this.getClass().getCanonicalName(), this.member);
    }

    protected static abstract class Builder<T extends Builder<T, U>, U extends AbstractRequest>
    implements Request.Builder<T, U> {
        protected final U request;

        protected Builder(U request) {
            this.request = request;
        }

        @Override
        public T withUri(String uri) {
            Assert.isNotNull(uri, "uri");
            ((AbstractRequest)this.request).member = uri;
            return (T)this;
        }

        @Override
        public U build() {
            Assert.isNotNull(((AbstractRequest)this.request).member, "uri");
            return this.request;
        }
    }
}

