/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft.protocol;

import java.util.Objects;
import net.kuujo.copycat.raft.protocol.Response;
import net.kuujo.copycat.util.internal.Assert;

abstract class AbstractResponse
implements Response {
    protected String member;
    protected Response.Status status = Response.Status.OK;
    protected Throwable error;

    AbstractResponse() {
    }

    @Override
    public String uri() {
        return this.member;
    }

    @Override
    public Response.Status status() {
        return this.status;
    }

    @Override
    public Throwable error() {
        return this.error;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.member, this.status});
    }

    public String toString() {
        return String.format("%s[uri=%s, status=%s]", new Object[]{this.getClass().getCanonicalName(), this.member, this.status});
    }

    protected static abstract class Builder<T extends Builder<T, U>, U extends AbstractResponse>
    implements Response.Builder<T, U> {
        protected final U response;

        protected Builder(U response) {
            this.response = response;
        }

        @Override
        public T withUri(String member) {
            Assert.isNotNull(member, "uri");
            ((AbstractResponse)this.response).member = member;
            return (T)this;
        }

        @Override
        public T withStatus(Response.Status status) {
            Assert.isNotNull(status, "status");
            ((AbstractResponse)this.response).status = status;
            return (T)this;
        }

        @Override
        public T withError(Throwable error) {
            Assert.isNotNull(error, "error");
            ((AbstractResponse)this.response).error = error;
            return (T)this;
        }

        @Override
        public U build() {
            Assert.isNotNull(((AbstractResponse)this.response).member, "uri");
            Assert.isNotNull(((AbstractResponse)this.response).status, "status");
            return this.response;
        }
    }
}

