/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft.protocol;

import java.util.Objects;
import net.kuujo.copycat.raft.protocol.AbstractResponse;
import net.kuujo.copycat.util.internal.Assert;

public class AppendResponse
extends AbstractResponse {
    private long term;
    private boolean succeeded;
    private Long logIndex;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AppendResponse response) {
        return new Builder(response);
    }

    public long term() {
        return this.term;
    }

    public boolean succeeded() {
        return this.succeeded;
    }

    public Long logIndex() {
        return this.logIndex;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.member, this.term, this.succeeded, this.logIndex);
    }

    public boolean equals(Object object) {
        if (object instanceof AppendResponse) {
            AppendResponse response = (AppendResponse)object;
            return response.status == this.status && response.member.equals(this.member) && response.term == this.term && response.succeeded == this.succeeded && response.logIndex.equals(this.logIndex);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[status=%s, term=%d, succeeded=%b, logIndex=%d]", new Object[]{this.getClass().getSimpleName(), this.status, this.term, this.succeeded, this.logIndex});
    }

    public static class Builder
    extends AbstractResponse.Builder<Builder, AppendResponse> {
        private Builder() {
            this(new AppendResponse());
        }

        private Builder(AppendResponse response) {
            super(response);
        }

        public Builder withTerm(long term) {
            ((AppendResponse)this.response).term = term;
            return this;
        }

        public Builder withSucceeded(boolean succeeded) {
            ((AppendResponse)this.response).succeeded = succeeded;
            return this;
        }

        public Builder withLogIndex(Long index) {
            ((AppendResponse)this.response).logIndex = Assert.index(index, index == null || index > 0L, "log index must be greater than zero", new Object[0]);
            return this;
        }

        @Override
        public AppendResponse build() {
            super.build();
            Assert.arg(((AppendResponse)this.response).term, ((AppendResponse)this.response).term > 0L, "term must be greater than zero", new Object[0]);
            Assert.index(((AppendResponse)this.response).logIndex, ((AppendResponse)this.response).logIndex == null || ((AppendResponse)this.response).logIndex > 0L, "log index must be greater than zero", new Object[0]);
            return (AppendResponse)this.response;
        }

        public int hashCode() {
            return Objects.hash(this.response);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((AppendResponse)((Builder)object).response).equals(this.response);
        }

        public String toString() {
            return String.format("%s[response=%s]", this.getClass().getCanonicalName(), this.response);
        }
    }
}

