/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft.protocol;

import java.nio.ByteBuffer;
import java.util.Objects;
import net.kuujo.copycat.raft.protocol.AbstractRequest;
import net.kuujo.copycat.util.internal.Assert;

public class CommitRequest
extends AbstractRequest {
    private ByteBuffer entry;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CommitRequest request) {
        return new Builder(request);
    }

    public ByteBuffer entry() {
        return this.entry;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.member, this.entry);
    }

    public boolean equals(Object object) {
        if (object instanceof CommitRequest) {
            CommitRequest request = (CommitRequest)object;
            return request.member.equals(this.member) && request.entry.equals(this.entry);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[entry=%s]", this.getClass().getSimpleName(), this.entry.toString());
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, CommitRequest> {
        private Builder() {
            this(new CommitRequest());
        }

        private Builder(CommitRequest request) {
            super(request);
        }

        public Builder withEntry(ByteBuffer entry) {
            ((CommitRequest)this.request).entry = Assert.isNotNull(entry, "entry");
            return this;
        }

        @Override
        public CommitRequest build() {
            super.build();
            Assert.isNotNull(((CommitRequest)this.request).entry, "entry");
            return (CommitRequest)this.request;
        }

        public int hashCode() {
            return Objects.hash(this.request);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((CommitRequest)((Builder)object).request).equals(this.request);
        }

        public String toString() {
            return String.format("%s[request=%s]", this.getClass().getCanonicalName(), this.request);
        }
    }
}

