/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft.protocol;

import java.util.Objects;
import net.kuujo.copycat.raft.protocol.AbstractRequest;
import net.kuujo.copycat.util.internal.Assert;

public class PollRequest
extends AbstractRequest {
    private long term;
    private String candidate;
    private Long logIndex;
    private Long logTerm;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PollRequest request) {
        return new Builder(request);
    }

    public long term() {
        return this.term;
    }

    public String candidate() {
        return this.candidate;
    }

    public Long logIndex() {
        return this.logIndex;
    }

    public Long logTerm() {
        return this.logTerm;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.member, this.term, this.candidate, this.logIndex, this.logTerm);
    }

    public boolean equals(Object object) {
        if (object instanceof PollRequest) {
            PollRequest request = (PollRequest)object;
            return request.member.equals(this.member) && request.term == this.term && request.candidate.equals(this.candidate) && request.logIndex.equals(this.logIndex) && request.logTerm.equals(this.logTerm);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[term=%d, candidate=%s, logIndex=%d, logTerm=%d]", this.getClass().getSimpleName(), this.term, this.candidate, this.logIndex, this.logTerm);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, PollRequest> {
        protected Builder() {
            this(new PollRequest());
        }

        protected Builder(PollRequest request) {
            super(request);
        }

        public Builder withTerm(long term) {
            ((PollRequest)this.request).term = Assert.arg(term, term >= 0L, "term must be greater than or equal to zero", new Object[0]);
            return this;
        }

        public Builder withCandidate(String candidate) {
            ((PollRequest)this.request).candidate = Assert.isNotNull(candidate, "candidate");
            return this;
        }

        public Builder withLogIndex(Long index) {
            ((PollRequest)this.request).logIndex = Assert.index(index, index == null || index > 0L, "index must be greater than zero", new Object[0]);
            return this;
        }

        public Builder withLogTerm(Long term) {
            ((PollRequest)this.request).logTerm = Assert.arg(term, term == null || term > 0L, "term must be greater than zero", new Object[0]);
            return this;
        }

        @Override
        public PollRequest build() {
            super.build();
            Assert.isNotNull(((PollRequest)this.request).candidate, "candidate");
            Assert.arg(((PollRequest)this.request).term, ((PollRequest)this.request).term >= 0L, "term must be greater than or equal to zero", new Object[0]);
            Assert.index(((PollRequest)this.request).logIndex, ((PollRequest)this.request).logIndex == null || ((PollRequest)this.request).logIndex > 0L, "index must be greater than zero", new Object[0]);
            Assert.arg(((PollRequest)this.request).logTerm, ((PollRequest)this.request).logTerm == null || ((PollRequest)this.request).logTerm >= 0L, "term must be greater than or equal to zero", new Object[0]);
            Assert.arg(null, ((PollRequest)this.request).logIndex == null && ((PollRequest)this.request).logTerm == null || ((PollRequest)this.request).logIndex != null && ((PollRequest)this.request).logTerm != null, "log index and term must both be null or neither be null", new Object[0]);
            return (PollRequest)this.request;
        }

        public int hashCode() {
            return Objects.hash(this.request);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((PollRequest)((Builder)object).request).equals(this.request);
        }

        public String toString() {
            return String.format("%s[request=%s]", this.getClass().getCanonicalName(), this.request);
        }
    }
}

