/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft.protocol;

import java.util.Objects;
import net.kuujo.copycat.raft.protocol.AbstractResponse;
import net.kuujo.copycat.util.internal.Assert;

public class PollResponse
extends AbstractResponse {
    private long term;
    private boolean accepted;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PollResponse response) {
        return new Builder(response);
    }

    public long term() {
        return this.term;
    }

    public boolean accepted() {
        return this.accepted;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.member, this.status, this.term, this.accepted});
    }

    public boolean equals(Object object) {
        if (object instanceof PollResponse) {
            PollResponse response = (PollResponse)object;
            return response.member.equals(this.member) && response.status == this.status && response.term == this.term && response.accepted == this.accepted;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[term=%d, accepted=%b]", this.getClass().getSimpleName(), this.term, this.accepted);
    }

    public static class Builder
    extends AbstractResponse.Builder<Builder, PollResponse> {
        protected Builder() {
            this(new PollResponse());
        }

        protected Builder(PollResponse response) {
            super(response);
        }

        public Builder withTerm(long term) {
            ((PollResponse)this.response).term = Assert.arg(term, term >= 0L, "term must be greater than or equal to zero", new Object[0]);
            return this;
        }

        public Builder withAccepted(boolean accepted) {
            ((PollResponse)this.response).accepted = accepted;
            return this;
        }

        @Override
        public PollResponse build() {
            super.build();
            Assert.arg(((PollResponse)this.response).term, ((PollResponse)this.response).term >= 0L, "term must be greater than or equal to zero", new Object[0]);
            return (PollResponse)this.response;
        }

        public int hashCode() {
            return Objects.hash(this.response);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((PollResponse)((Builder)object).response).equals(this.response);
        }

        public String toString() {
            return String.format("%s[response=%s]", this.getClass().getCanonicalName(), this.response);
        }
    }
}

