/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft.protocol;

import java.io.Serializable;
import java.util.Objects;

public class ReplicaInfo
implements Serializable {
    private String uri;
    private long version = 1L;
    private Long index;

    public ReplicaInfo() {
    }

    public ReplicaInfo(String uri) {
        this(uri, 1L, null);
    }

    public ReplicaInfo(String uri, long version, Long index) {
        this.uri = uri;
        this.version = version;
        this.index = index;
    }

    public String getUri() {
        return this.uri;
    }

    public long getVersion() {
        return this.version;
    }

    public ReplicaInfo setVersion(long version) {
        this.version = version;
        return this;
    }

    public Long getIndex() {
        return this.index;
    }

    public ReplicaInfo setIndex(Long index) {
        this.index = index;
        return this;
    }

    public void update(ReplicaInfo info) {
        if (info.version > this.version) {
            this.version = info.version;
            this.index = info.index;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ReplicaInfo) {
            ReplicaInfo replica = (ReplicaInfo)object;
            return replica.uri.equals(this.uri) && replica.version == this.version && replica.index.equals(this.index);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.version, this.index);
    }

    public String toString() {
        return String.format("MemberInfo[uri=%s, version=%d, index=%s]", this.uri, this.version, this.index);
    }
}

