/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft.protocol;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.kuujo.copycat.raft.protocol.AbstractRequest;
import net.kuujo.copycat.raft.protocol.ReplicaInfo;
import net.kuujo.copycat.util.internal.Assert;

public class SyncRequest
extends AbstractRequest {
    private long term;
    private String leader;
    private Long logIndex;
    private boolean firstIndex;
    private List<ByteBuffer> entries;
    private Collection<ReplicaInfo> members;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SyncRequest request) {
        return new Builder(request);
    }

    public long term() {
        return this.term;
    }

    public String leader() {
        return this.leader;
    }

    public Long logIndex() {
        return this.logIndex;
    }

    public boolean firstIndex() {
        return this.firstIndex;
    }

    public List<ByteBuffer> entries() {
        return this.entries;
    }

    public Collection<ReplicaInfo> members() {
        return this.members;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.member, this.term, this.leader, this.entries);
    }

    public boolean equals(Object object) {
        if (object instanceof SyncRequest) {
            SyncRequest request = (SyncRequest)object;
            return request.member.equals(this.member) && request.term == this.term && request.leader.equals(this.leader) && request.logIndex.equals(this.logIndex) && request.firstIndex == this.firstIndex && request.entries.equals(this.entries) && request.members.equals(this.members);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[term=%d, leader=%s, logIndex=%s, firstIndex=%b, entries=[%d]]", this.getClass().getSimpleName(), this.term, this.leader, this.logIndex, this.firstIndex, this.entries.size());
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, SyncRequest> {
        private Builder() {
            this(new SyncRequest());
        }

        private Builder(SyncRequest request) {
            super(request);
        }

        public Builder withTerm(long term) {
            ((SyncRequest)this.request).term = Assert.arg(term, term >= 0L, "term must be greater than zero", new Object[0]);
            return this;
        }

        public Builder withLeader(String leader) {
            ((SyncRequest)this.request).leader = leader;
            return this;
        }

        public Builder withEntries(ByteBuffer ... entries) {
            return this.withEntries(Arrays.asList(entries));
        }

        public Builder withEntries(List<ByteBuffer> entries) {
            ((SyncRequest)this.request).entries = Assert.isNotNull(entries, "entries");
            return this;
        }

        public Builder withLogIndex(Long index) {
            ((SyncRequest)this.request).logIndex = index;
            return this;
        }

        public Builder withFirstIndex(boolean firstIndex) {
            ((SyncRequest)this.request).firstIndex = firstIndex;
            return this;
        }

        public Builder withMembers(Collection<ReplicaInfo> members) {
            ((SyncRequest)this.request).members = Assert.isNotNull(members, "members");
            return this;
        }

        @Override
        public SyncRequest build() {
            super.build();
            Assert.arg(((SyncRequest)this.request).term, ((SyncRequest)this.request).term >= 0L, "term must be greater than zero", new Object[0]);
            Assert.isNotNull(((SyncRequest)this.request).entries, "entries");
            Assert.isNotNull(((SyncRequest)this.request).members, "members");
            return (SyncRequest)this.request;
        }

        public int hashCode() {
            return Objects.hash(this.request);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((SyncRequest)((Builder)object).request).equals(this.request);
        }

        public String toString() {
            return String.format("%s[request=%s]", this.getClass().getCanonicalName(), this.request);
        }
    }
}

