/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft.protocol;

import java.util.Collection;
import java.util.Objects;
import net.kuujo.copycat.raft.protocol.AbstractResponse;
import net.kuujo.copycat.raft.protocol.ReplicaInfo;
import net.kuujo.copycat.util.internal.Assert;

public class SyncResponse
extends AbstractResponse {
    private Collection<ReplicaInfo> members;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SyncResponse response) {
        return new Builder(response);
    }

    public Collection<ReplicaInfo> members() {
        return this.members;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.member, this.members);
    }

    public boolean equals(Object object) {
        if (object instanceof SyncResponse) {
            SyncResponse response = (SyncResponse)object;
            return response.status == this.status && response.member.equals(this.member) && response.members.equals(this.members);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[members=%s]", this.getClass().getSimpleName(), this.members);
    }

    public static class Builder
    extends AbstractResponse.Builder<Builder, SyncResponse> {
        private Builder() {
            this(new SyncResponse());
        }

        private Builder(SyncResponse response) {
            super(response);
        }

        public Builder withMembers(Collection<ReplicaInfo> members) {
            ((SyncResponse)this.response).members = Assert.isNotNull(members, "members");
            return this;
        }

        @Override
        public SyncResponse build() {
            super.build();
            Assert.isNotNull(((SyncResponse)this.response).members, "members");
            return (SyncResponse)this.response;
        }

        public int hashCode() {
            return Objects.hash(this.response);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((SyncResponse)((Builder)object).response).equals(this.response);
        }

        public String toString() {
            return String.format("%s[response=%s]", this.getClass().getCanonicalName(), this.response);
        }
    }
}

