/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft.protocol;

import java.util.Objects;
import net.kuujo.copycat.raft.protocol.AbstractRequest;
import net.kuujo.copycat.util.internal.Assert;

public class VoteRequest
extends AbstractRequest {
    private long term;
    private String candidate;
    private Long logIndex;
    private Long logTerm;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(VoteRequest request) {
        return new Builder(request);
    }

    public long term() {
        return this.term;
    }

    public String candidate() {
        return this.candidate;
    }

    public Long logIndex() {
        return this.logIndex;
    }

    public Long logTerm() {
        return this.logTerm;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.member, this.term, this.candidate, this.logIndex, this.logTerm);
    }

    public boolean equals(Object object) {
        if (object instanceof VoteRequest) {
            VoteRequest request = (VoteRequest)object;
            return request.member.equals(this.member) && request.term == this.term && request.candidate.equals(this.candidate) && request.logIndex.equals(this.logIndex) && request.logTerm.equals(this.logTerm);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[term=%d, candidate=%s, logIndex=%d, logTerm=%d]", this.getClass().getSimpleName(), this.term, this.candidate, this.logIndex, this.logTerm);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, VoteRequest> {
        protected Builder() {
            this(new VoteRequest());
        }

        protected Builder(VoteRequest request) {
            super(request);
        }

        public Builder withTerm(long term) {
            ((VoteRequest)this.request).term = Assert.arg(term, term > 0L, "term must be greater than zero", new Object[0]);
            return this;
        }

        public Builder withCandidate(String candidate) {
            ((VoteRequest)this.request).candidate = Assert.isNotNull(candidate, "candidate");
            return this;
        }

        public Builder withLogIndex(Long index) {
            ((VoteRequest)this.request).logIndex = Assert.index(index, index == null || index > 0L, "index must be greater than zero", new Object[0]);
            return this;
        }

        public Builder withLogTerm(Long term) {
            ((VoteRequest)this.request).logTerm = Assert.arg(term, term == null || term > 0L, "term must be greater than zero", new Object[0]);
            return this;
        }

        @Override
        public VoteRequest build() {
            super.build();
            Assert.isNotNull(((VoteRequest)this.request).candidate, "candidate");
            Assert.arg(((VoteRequest)this.request).term, ((VoteRequest)this.request).term > 0L, "term must be greater than zero", new Object[0]);
            Assert.index(((VoteRequest)this.request).logIndex, ((VoteRequest)this.request).logIndex == null || ((VoteRequest)this.request).logIndex > 0L, "index must be greater than zero", new Object[0]);
            Assert.arg(((VoteRequest)this.request).logTerm, ((VoteRequest)this.request).logTerm == null || ((VoteRequest)this.request).logTerm > 0L, "term must be greater than zero", new Object[0]);
            Assert.arg(null, ((VoteRequest)this.request).logIndex == null && ((VoteRequest)this.request).logTerm == null || ((VoteRequest)this.request).logIndex != null && ((VoteRequest)this.request).logTerm != null, "log index and term must both be null or neither be null", new Object[0]);
            return (VoteRequest)this.request;
        }

        public int hashCode() {
            return Objects.hash(this.request);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((VoteRequest)((Builder)object).request).equals(this.request);
        }

        public String toString() {
            return String.format("%s[request=%s]", this.getClass().getCanonicalName(), this.request);
        }
    }
}

