/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.raft.protocol;

import java.util.Objects;
import net.kuujo.copycat.raft.protocol.AbstractResponse;
import net.kuujo.copycat.util.internal.Assert;

public class VoteResponse
extends AbstractResponse {
    private long term;
    private boolean voted;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(VoteResponse response) {
        return new Builder(response);
    }

    public long term() {
        return this.term;
    }

    public boolean voted() {
        return this.voted;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.member, this.status, this.term, this.voted});
    }

    public boolean equals(Object object) {
        if (object instanceof VoteResponse) {
            VoteResponse response = (VoteResponse)object;
            return response.member.equals(this.member) && response.status == this.status && response.term == this.term && response.voted == this.voted;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[term=%d, voted=%b]", this.getClass().getSimpleName(), this.term, this.voted);
    }

    public static class Builder
    extends AbstractResponse.Builder<Builder, VoteResponse> {
        protected Builder() {
            this(new VoteResponse());
        }

        protected Builder(VoteResponse response) {
            super(response);
        }

        public Builder withTerm(long term) {
            ((VoteResponse)this.response).term = Assert.arg(term, term > 0L, "term must be greater than zero", new Object[0]);
            return this;
        }

        public Builder withVoted(boolean voted) {
            ((VoteResponse)this.response).voted = voted;
            return this;
        }

        @Override
        public VoteResponse build() {
            super.build();
            Assert.arg(((VoteResponse)this.response).term, ((VoteResponse)this.response).term > 0L, "term must be greater than zero", new Object[0]);
            return (VoteResponse)this.response;
        }

        public int hashCode() {
            return Objects.hash(this.response);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((VoteResponse)((Builder)object).response).equals(this.response);
        }

        public String toString() {
            return String.format("%s[response=%s]", this.getClass().getCanonicalName(), this.response);
        }
    }
}

