/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.resource;

import com.typesafe.config.ConfigValueFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatedResourceConfig;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.util.AbstractConfigurable;
import net.kuujo.copycat.util.Configurable;
import net.kuujo.copycat.util.ConfigurationException;
import net.kuujo.copycat.util.internal.Assert;
import net.kuujo.copycat.util.serializer.KryoSerializer;
import net.kuujo.copycat.util.serializer.Serializer;

public abstract class ResourceConfig<T extends ResourceConfig<T>>
extends AbstractConfigurable {
    private static final String RESOURCE_SERIALIZER = "serializer";
    private static final String RESOURCE_ELECTION_TIMEOUT = "election.timeout";
    private static final String RESOURCE_HEARTBEAT_INTERVAL = "heartbeat.interval";
    private static final String RESOURCE_REPLICAS = "replicas";
    private static final String RESOURCE_LOG = "log";
    private static final String CONFIGURATION = "resource";
    private static final String DEFAULT_CONFIGURATION = "resource-defaults";
    private Serializer defaultSerializer;
    private Executor executor;

    protected ResourceConfig() {
        super(CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    protected ResourceConfig(Map<String, Object> config, String ... resources) {
        super(config, ResourceConfig.addResources(resources, CONFIGURATION, DEFAULT_CONFIGURATION));
    }

    protected ResourceConfig(T config) {
        super((Configurable)config);
    }

    protected ResourceConfig(String ... resources) {
        super(ResourceConfig.addResources(resources, CONFIGURATION, DEFAULT_CONFIGURATION));
    }

    @Override
    public T copy() {
        try {
            return (T)((ResourceConfig)this.getClass().getConstructor(this.getClass()).newInstance(this));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigurationException("Failed to instantiate configuration via copy constructor", new Object[]{e});
        }
    }

    public void setSerializer(String serializer) {
        try {
            this.setSerializer((Serializer)Class.forName(Assert.isNotNull(serializer, RESOURCE_SERIALIZER)).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate serializer", new Object[]{e});
        }
    }

    public Serializer getDefaultSerializer() {
        return this.defaultSerializer != null ? this.defaultSerializer : new KryoSerializer();
    }

    public void setDefaultSerializer(Serializer serializer) {
        this.defaultSerializer = Assert.isNotNull(serializer, RESOURCE_SERIALIZER);
    }

    public T withDefaultSerializer(Serializer serializer) {
        this.setDefaultSerializer(serializer);
        return (T)this;
    }

    public void setSerializer(Class<? extends Serializer> serializer) {
        try {
            this.setSerializer(Assert.isNotNull(serializer, RESOURCE_SERIALIZER).newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate serializer", new Object[]{e});
        }
    }

    public void setSerializer(Serializer serializer) {
        this.config = this.config.withValue(RESOURCE_SERIALIZER, ConfigValueFactory.fromMap(Assert.isNotNull(serializer, RESOURCE_SERIALIZER).toMap()));
    }

    public Serializer getSerializer() {
        return this.config.hasPath(RESOURCE_SERIALIZER) ? (Serializer)Configurable.load(this.config.getObject(RESOURCE_SERIALIZER).unwrapped()) : this.getDefaultSerializer();
    }

    public T withSerializer(String serializer) {
        this.setSerializer(serializer);
        return (T)this;
    }

    public T withSerializer(Class<? extends Serializer> serializer) {
        this.setSerializer(serializer);
        return (T)this;
    }

    public T withSerializer(Serializer serializer) {
        this.setSerializer(serializer);
        return (T)this;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public T withExecutor(Executor executor) {
        this.setExecutor(executor);
        return (T)this;
    }

    public void setElectionTimeout(long electionTimeout) {
        this.config = this.config.withValue(RESOURCE_ELECTION_TIMEOUT, ConfigValueFactory.fromAnyRef(Assert.arg(electionTimeout, electionTimeout > 0L, "election timeout must be positive", new Object[0])));
    }

    public void setElectionTimeout(long electionTimeout, TimeUnit unit) {
        this.setElectionTimeout(unit.toMillis(electionTimeout));
    }

    public long getElectionTimeout() {
        return this.config.getLong(RESOURCE_ELECTION_TIMEOUT);
    }

    public T withElectionTimeout(long electionTimeout) {
        this.setElectionTimeout(electionTimeout);
        return (T)this;
    }

    public T withElectionTimeout(long electionTimeout, TimeUnit unit) {
        this.setElectionTimeout(electionTimeout, unit);
        return (T)this;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.config = this.config.withValue(RESOURCE_HEARTBEAT_INTERVAL, ConfigValueFactory.fromAnyRef(Assert.arg(heartbeatInterval, heartbeatInterval > 0L, "heartbeat interval must be positive", new Object[0])));
    }

    public void setHeartbeatInterval(long heartbeatInterval, TimeUnit unit) {
        this.setHeartbeatInterval(unit.toMillis(heartbeatInterval));
    }

    public long getHeartbeatInterval() {
        return this.config.getLong(RESOURCE_HEARTBEAT_INTERVAL);
    }

    public T withHeartbeatInterval(long heartbeatInterval) {
        this.setHeartbeatInterval(heartbeatInterval);
        return (T)this;
    }

    public T withHeartbeatInterval(long heartbeatInterval, TimeUnit unit) {
        this.setHeartbeatInterval(heartbeatInterval, unit);
        return (T)this;
    }

    public void setReplicas(String ... replicas) {
        this.setReplicas(Arrays.asList(replicas));
    }

    public void setReplicas(Collection<String> replicas) {
        this.config = this.config.withValue(RESOURCE_REPLICAS, ConfigValueFactory.fromIterable(new HashSet<String>(Assert.isNotNull(replicas, RESOURCE_REPLICAS))));
    }

    public Set<String> getReplicas() {
        return new HashSet<String>(this.config.hasPath(RESOURCE_REPLICAS) ? this.config.getList(RESOURCE_REPLICAS).unwrapped() : new ArrayList(0));
    }

    public T withReplicas(String ... replicas) {
        this.setReplicas(Arrays.asList(replicas));
        return (T)this;
    }

    public T withReplicas(Collection<String> replicas) {
        this.setReplicas(replicas);
        return (T)this;
    }

    public T addReplica(String replica) {
        if (!this.config.hasPath(RESOURCE_REPLICAS)) {
            this.config = this.config.withValue(RESOURCE_REPLICAS, ConfigValueFactory.fromIterable(new ArrayList(1)));
        }
        List<Object> replicas = this.config.getList(RESOURCE_REPLICAS).unwrapped();
        replicas.add(Assert.isNotNull(replica, "replica"));
        this.config = this.config.withValue(RESOURCE_REPLICAS, ConfigValueFactory.fromIterable(replicas));
        return (T)this;
    }

    public T removeReplica(String replica) {
        List<Object> replicas = this.config.getList(RESOURCE_REPLICAS).unwrapped();
        replicas.remove(Assert.isNotNull(replica, "replica"));
        this.config = this.config.withValue(RESOURCE_REPLICAS, ConfigValueFactory.fromIterable(replicas));
        return (T)this;
    }

    public T clearReplicas() {
        this.config = this.config.withoutPath(RESOURCE_REPLICAS);
        return (T)this;
    }

    public void setLog(Log log) {
        this.config = this.config.withValue(RESOURCE_LOG, ConfigValueFactory.fromMap(log.toMap()));
    }

    public Log getLog() {
        return (Log)Configurable.load(this.config.getObject(RESOURCE_LOG).unwrapped());
    }

    public T withLog(Log log) {
        this.setLog(log);
        return (T)this;
    }

    public abstract CoordinatedResourceConfig resolve(ClusterConfig var1);
}

