/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.resource.internal;

import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatedResourceConfig;
import net.kuujo.copycat.cluster.internal.coordinator.DefaultClusterCoordinator;
import net.kuujo.copycat.cluster.internal.manager.ClusterManager;
import net.kuujo.copycat.log.LogManager;
import net.kuujo.copycat.protocol.Consistency;
import net.kuujo.copycat.raft.RaftContext;
import net.kuujo.copycat.raft.protocol.CommitRequest;
import net.kuujo.copycat.raft.protocol.QueryRequest;
import net.kuujo.copycat.raft.protocol.Response;
import net.kuujo.copycat.resource.ResourceState;
import net.kuujo.copycat.util.Managed;
import net.kuujo.copycat.util.concurrent.Futures;
import net.kuujo.copycat.util.function.TriFunction;
import net.kuujo.copycat.util.internal.Assert;

public class ResourceManager
implements Managed<ResourceManager> {
    private final String name;
    private final CoordinatedResourceConfig config;
    private final ClusterManager cluster;
    private final RaftContext context;
    private final DefaultClusterCoordinator coordinator;
    private volatile boolean open;

    public ResourceManager(String name, CoordinatedResourceConfig config, ClusterManager cluster, RaftContext context, DefaultClusterCoordinator coordinator) {
        this.name = Assert.isNotNull(name, "name");
        this.config = Assert.isNotNull(config, "config");
        this.cluster = Assert.isNotNull(cluster, "cluster");
        this.context = Assert.isNotNull(context, "context");
        this.coordinator = Assert.isNotNull(coordinator, "coordinator");
    }

    public String name() {
        return this.name;
    }

    public CoordinatedResourceConfig config() {
        return this.config;
    }

    public ResourceState state() {
        return this.context.isRecovering() ? ResourceState.RECOVER : ResourceState.HEALTHY;
    }

    public ClusterManager cluster() {
        return this.cluster;
    }

    public LogManager log() {
        return this.context.log();
    }

    public void execute(Runnable command) {
        this.context.executor().execute(command);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.context.executor().schedule(command, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.context.executor().schedule(callable, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.context.executor().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.context.executor().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public synchronized ResourceManager consumer(TriFunction<Long, Long, ByteBuffer, ByteBuffer> consumer) {
        this.context.consumer(consumer);
        return this;
    }

    public synchronized CompletableFuture<ByteBuffer> query(ByteBuffer entry) {
        return this.query(entry, Consistency.DEFAULT);
    }

    public synchronized CompletableFuture<ByteBuffer> query(ByteBuffer entry, Consistency consistency) {
        if (!this.open) {
            return Futures.exceptionalFuture(new IllegalStateException("Context not open"));
        }
        CompletableFuture<ByteBuffer> future = new CompletableFuture<ByteBuffer>();
        QueryRequest request = ((QueryRequest.Builder)QueryRequest.builder().withUri(this.context.getLocalMember())).withEntry(entry).withConsistency(consistency).build();
        this.context.query(request).whenComplete((response, error) -> {
            if (error == null) {
                if (response.status() == Response.Status.OK) {
                    future.complete(response.result());
                } else {
                    future.completeExceptionally(response.error());
                }
            } else {
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    public synchronized CompletableFuture<ByteBuffer> commit(ByteBuffer entry) {
        if (!this.open) {
            return Futures.exceptionalFuture(new IllegalStateException("Context not open"));
        }
        CompletableFuture<ByteBuffer> future = new CompletableFuture<ByteBuffer>();
        CommitRequest request = ((CommitRequest.Builder)CommitRequest.builder().withUri(this.context.getLocalMember())).withEntry(entry).build();
        this.context.commit(request).whenComplete((response, error) -> {
            if (error == null) {
                if (response.status() == Response.Status.OK) {
                    future.complete(response.result());
                } else {
                    future.completeExceptionally(response.error());
                }
            } else {
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    @Override
    public synchronized CompletableFuture<ResourceManager> open() {
        return ((CompletableFuture)this.coordinator.acquireResource(this.name).thenRun(() -> {
            this.open = true;
        })).thenApply(v -> this);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return this.coordinator.releaseResource(this.name).thenRun(() -> {
            this.open = false;
        });
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }
}

