/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.state;

import com.typesafe.config.ConfigValueFactory;
import java.util.Map;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatedResourceConfig;
import net.kuujo.copycat.protocol.Consistency;
import net.kuujo.copycat.resource.ResourceConfig;
import net.kuujo.copycat.state.internal.DefaultStateLog;
import net.kuujo.copycat.state.internal.SnapshottableLog;
import net.kuujo.copycat.util.internal.Assert;

public class StateLogConfig
extends ResourceConfig<StateLogConfig> {
    private static final String STATE_LOG_CONSISTENCY = "consistency";
    private static final String DEFAULT_CONFIGURATION = "event-log-defaults";
    private static final String CONFIGURATION = "event-log";

    public StateLogConfig() {
        super(CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    public StateLogConfig(Map<String, Object> config) {
        super(config, CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    public StateLogConfig(String resource) {
        super(resource, CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    protected StateLogConfig(String ... resources) {
        super(StateLogConfig.addResources(resources, CONFIGURATION, DEFAULT_CONFIGURATION));
    }

    protected StateLogConfig(Map<String, Object> config, String ... resources) {
        super(config, StateLogConfig.addResources(resources, CONFIGURATION, DEFAULT_CONFIGURATION));
    }

    protected StateLogConfig(StateLogConfig config) {
        super(config);
    }

    @Override
    public StateLogConfig copy() {
        return new StateLogConfig(this);
    }

    public void setDefaultConsistency(String consistency) {
        this.config = this.config.withValue(STATE_LOG_CONSISTENCY, ConfigValueFactory.fromAnyRef(Consistency.parse(Assert.isNotNull(consistency, STATE_LOG_CONSISTENCY)).toString()));
    }

    public void setDefaultConsistency(Consistency consistency) {
        this.config = this.config.withValue(STATE_LOG_CONSISTENCY, ConfigValueFactory.fromAnyRef(Assert.isNotNull(consistency, STATE_LOG_CONSISTENCY).toString()));
    }

    public Consistency getDefaultConsistency() {
        return Consistency.parse(this.config.getString(STATE_LOG_CONSISTENCY));
    }

    public StateLogConfig withDefaultConsistency(String consistency) {
        this.setDefaultConsistency(consistency);
        return this;
    }

    public StateLogConfig withDefaultConsistency(Consistency consistency) {
        this.setDefaultConsistency(consistency);
        return this;
    }

    @Override
    public CoordinatedResourceConfig resolve(ClusterConfig cluster) {
        Assert.config(this.getReplicas(), this.getReplicas().isEmpty() || cluster.getMembers().containsAll(this.getReplicas()), "Resource replica set must contain only active cluster members", new Object[0]);
        return new CoordinatedResourceConfig(super.toMap()).withElectionTimeout(this.getElectionTimeout()).withHeartbeatInterval(this.getHeartbeatInterval()).withResourceType(DefaultStateLog.class).withLog(new SnapshottableLog(this.getLog())).withSerializer(this.getSerializer()).withExecutor(this.getExecutor()).withResourceConfig(this).withReplicas(this.getReplicas().isEmpty() ? cluster.getMembers() : this.getReplicas());
    }
}

