/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.state.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.TreeMap;
import net.kuujo.copycat.log.LogConfig;
import net.kuujo.copycat.log.LogManager;
import net.kuujo.copycat.log.LogSegment;
import net.kuujo.copycat.util.internal.Assert;

public class SnapshottableLogManager
implements LogManager {
    private final LogManager logManager;
    private final LogManager snapshotManager;

    public SnapshottableLogManager(LogManager logManager, LogManager snapshotManager) {
        this.logManager = logManager;
        this.snapshotManager = snapshotManager;
    }

    @Override
    public LogConfig config() {
        return this.logManager.config();
    }

    @Override
    public TreeMap<Long, LogSegment> segments() {
        return this.logManager.segments();
    }

    @Override
    public LogSegment segment() {
        return this.logManager.segment();
    }

    @Override
    public LogSegment segment(long index) {
        return this.snapshotManager.lastIndex() == null || index > this.snapshotManager.lastIndex() ? this.logManager.segment(index) : this.snapshotManager.segment(index);
    }

    @Override
    public LogSegment firstSegment() {
        return this.snapshotManager.isEmpty() ? this.logManager.firstSegment() : this.snapshotManager.firstSegment();
    }

    @Override
    public LogSegment lastSegment() {
        return this.logManager.lastSegment();
    }

    @Override
    public void open() throws IOException {
        this.snapshotManager.open();
        this.logManager.open();
    }

    @Override
    public boolean isEmpty() {
        return this.snapshotManager.isEmpty() && this.logManager.isEmpty();
    }

    @Override
    public boolean isOpen() {
        return this.snapshotManager.isOpen() && this.logManager.isOpen();
    }

    @Override
    public long size() {
        return this.snapshotManager.size() + this.logManager.size();
    }

    @Override
    public long entryCount() {
        return this.snapshotManager.entryCount() + this.logManager.entryCount();
    }

    public boolean isSnapshottable(long index) {
        if (!this.logManager.containsIndex(index)) {
            return false;
        }
        LogSegment segment = this.logManager.segment(index);
        if (segment == null) {
            return false;
        }
        if (segment.lastIndex() == null || segment.lastIndex() != index) {
            return false;
        }
        return segment != this.logManager.lastSegment();
    }

    public long appendSnapshot(long index, List<ByteBuffer> snapshot) throws IOException {
        LogSegment segment = this.logManager.segment(index);
        if (segment == null) {
            throw new IndexOutOfBoundsException("Invalid snapshot index " + index);
        }
        if (segment.lastIndex() != index) {
            throw new IllegalArgumentException("Snapshot index must be the last index of a segment");
        }
        if (segment == this.logManager.lastSegment()) {
            throw new IllegalArgumentException("Cannot snapshot current log segment");
        }
        this.snapshotManager.rollOver(index - (long)snapshot.size() + 1L);
        for (ByteBuffer entry : snapshot) {
            this.snapshotManager.appendEntry(entry);
        }
        this.snapshotManager.compact(index - (long)snapshot.size() + 1L);
        this.logManager.compact(index + 1L);
        return index;
    }

    @Override
    public long appendEntry(ByteBuffer entry) throws IOException {
        return this.logManager.appendEntry(entry);
    }

    @Override
    public long index() {
        return this.snapshotManager.index();
    }

    @Override
    public Long firstIndex() {
        return !this.snapshotManager.isEmpty() ? this.snapshotManager.firstIndex() : this.logManager.firstIndex();
    }

    @Override
    public Long lastIndex() {
        return this.logManager.lastIndex();
    }

    @Override
    public boolean containsIndex(long index) {
        Assert.state(this.isOpen(), "Log is not open", new Object[0]);
        return this.logManager.containsIndex(index) || this.snapshotManager.containsIndex(index);
    }

    @Override
    public ByteBuffer getEntry(long index) {
        Assert.state(this.isOpen(), "Log is not open", new Object[0]);
        if (this.logManager.containsIndex(index)) {
            return this.logManager.getEntry(index);
        }
        if (this.snapshotManager.containsIndex(index)) {
            return this.snapshotManager.getEntry(index);
        }
        throw new IndexOutOfBoundsException("No entry at index " + index);
    }

    @Override
    public void removeAfter(long index) {
        Assert.state(this.isOpen(), "Log is not open", new Object[0]);
        Assert.index(index, this.logManager.containsIndex(index), "Log index out of bounds", new Object[0]);
        this.logManager.removeAfter(index);
    }

    @Override
    public void split(long index) throws IOException {
        this.logManager.split(index);
    }

    @Override
    public void rollOver(long index) throws IOException {
        this.logManager.rollOver(index);
        this.snapshotManager.rollOver(index);
    }

    @Override
    public void compact(long index) throws IOException {
        this.logManager.compact(index);
        this.snapshotManager.compact(index);
    }

    @Override
    public void flush() {
        this.logManager.flush();
    }

    @Override
    public void close() throws IOException {
        this.logManager.close();
        this.snapshotManager.close();
    }

    @Override
    public boolean isClosed() {
        return this.logManager.isClosed();
    }

    @Override
    public void delete() {
        this.logManager.delete();
        this.snapshotManager.delete();
    }
}

