/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.util.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.typesafe.config.ConfigValueFactory;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kuujo.copycat.cluster.internal.MemberInfo;
import net.kuujo.copycat.raft.protocol.AppendRequest;
import net.kuujo.copycat.raft.protocol.AppendResponse;
import net.kuujo.copycat.raft.protocol.CommitRequest;
import net.kuujo.copycat.raft.protocol.CommitResponse;
import net.kuujo.copycat.raft.protocol.PollRequest;
import net.kuujo.copycat.raft.protocol.PollResponse;
import net.kuujo.copycat.raft.protocol.QueryRequest;
import net.kuujo.copycat.raft.protocol.QueryResponse;
import net.kuujo.copycat.raft.protocol.ReplicaInfo;
import net.kuujo.copycat.raft.protocol.SyncRequest;
import net.kuujo.copycat.raft.protocol.SyncResponse;
import net.kuujo.copycat.raft.protocol.VoteRequest;
import net.kuujo.copycat.raft.protocol.VoteResponse;
import net.kuujo.copycat.util.ConfigurationException;
import net.kuujo.copycat.util.internal.Assert;
import net.kuujo.copycat.util.serializer.SerializerConfig;

public class KryoSerializer
extends SerializerConfig {
    private static final String KRYO_SERIALIZER_BUFFER_SIZE = "buffer.size";
    private static final String KRYO_SERIALIZER_REGISTRATIONS = "registrations";
    private static final int DEFAULT_KRYO_SERIALIZER_BUFFER_SIZE = 0x1000000;
    private static Map<String, Object> idToClassMap = new HashMap<String, Object>();
    private Kryo kryo = new Kryo();
    private ByteBufferOutput output;
    private ByteBufferInput input;
    private AtomicBoolean init = new AtomicBoolean();

    public KryoSerializer() {
    }

    public KryoSerializer(Map<String, Object> config) {
        super(config, new String[0]);
    }

    public KryoSerializer(String resource) {
        super(resource);
    }

    public KryoSerializer(KryoSerializer serializer) {
        super(serializer);
    }

    private void init() {
        if (this.init.compareAndSet(false, true)) {
            this.input = new ByteBufferInput();
            this.output = new ByteBufferOutput(ByteBuffer.allocateDirect(this.getBufferSize()));
            this.register();
        }
    }

    private void register() {
        Map<String, Object> regMap = this.config.hasPath(KRYO_SERIALIZER_REGISTRATIONS) ? this.config.getObject(KRYO_SERIALIZER_REGISTRATIONS).unwrapped() : idToClassMap;
        for (Map.Entry<String, Object> entry : regMap.entrySet()) {
            Object type = entry.getValue();
            if (type instanceof Class) {
                this.register((Class)type, Integer.valueOf(entry.getKey()));
                continue;
            }
            if (!(type instanceof String)) continue;
            try {
                this.register(Class.forName(type.toString()), Integer.valueOf(entry.getKey()));
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Failed to register serializer class", new Object[]{e});
            }
        }
    }

    public synchronized KryoSerializer register(Class<?> type) {
        this.kryo.register(type);
        return this;
    }

    public synchronized KryoSerializer register(Class<?> type, int id) {
        this.kryo.register(type, id);
        return this;
    }

    public void setBufferSize(int bufferSize) {
        this.config = this.config.withValue(KRYO_SERIALIZER_BUFFER_SIZE, ConfigValueFactory.fromAnyRef(Assert.arg(bufferSize, bufferSize > 0, "buffer size must be positive", new Object[0])));
    }

    public int getBufferSize() {
        return this.config.hasPath(KRYO_SERIALIZER_BUFFER_SIZE) ? this.config.getInt(KRYO_SERIALIZER_BUFFER_SIZE) : 0x1000000;
    }

    public KryoSerializer withBufferSize(int bufferSize) {
        this.setBufferSize(bufferSize);
        return this;
    }

    @Override
    public synchronized <T> T readObject(ByteBuffer buffer) {
        this.init();
        this.input.setBuffer(buffer);
        return (T)this.kryo.readClassAndObject((Input)this.input);
    }

    @Override
    public synchronized ByteBuffer writeObject(Object object) {
        this.init();
        this.kryo.writeClassAndObject((Output)this.output, object);
        byte[] bytes = this.output.toBytes();
        this.output.clear();
        return ByteBuffer.wrap(bytes);
    }

    static {
        idToClassMap.put(String.valueOf(101), SyncRequest.class);
        idToClassMap.put(String.valueOf(102), SyncResponse.class);
        idToClassMap.put(String.valueOf(103), PollRequest.class);
        idToClassMap.put(String.valueOf(104), PollResponse.class);
        idToClassMap.put(String.valueOf(105), VoteRequest.class);
        idToClassMap.put(String.valueOf(106), VoteResponse.class);
        idToClassMap.put(String.valueOf(107), AppendRequest.class);
        idToClassMap.put(String.valueOf(108), AppendResponse.class);
        idToClassMap.put(String.valueOf(109), QueryRequest.class);
        idToClassMap.put(String.valueOf(110), QueryResponse.class);
        idToClassMap.put(String.valueOf(111), CommitRequest.class);
        idToClassMap.put(String.valueOf(112), CommitResponse.class);
        idToClassMap.put(String.valueOf(113), ReplicaInfo.class);
        idToClassMap.put(String.valueOf(114), MemberInfo.class);
    }
}

