/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;

public class JsonCodecTest {
    @Test
    public void encode() {
        Foo f1 = new Foo("foo");
        Foo f2 = new Foo("bar");
        FooCodec codec = new FooCodec();
        ImmutableList entities = ImmutableList.of((Object)f1, (Object)f2);
        ArrayNode json = codec.encode((Iterable)entities, new TestContext());
        List foos = codec.decode(json, new TestContext());
        Assert.assertEquals((String)"incorrect encode/decode", (Object)entities, (Object)foos);
    }

    private class TestContext
    implements CodecContext {
        private ObjectMapper mapper = new ObjectMapper();

        private TestContext() {
        }

        public ObjectMapper mapper() {
            return this.mapper;
        }

        public <T> JsonCodec<T> codec(Class<T> entityClass) {
            return null;
        }

        public <T> T get(Class<T> serviceClass) {
            return null;
        }
    }

    private static class FooCodec
    extends JsonCodec<Foo> {
        private FooCodec() {
        }

        public ObjectNode encode(Foo entity, CodecContext context) {
            return context.mapper().createObjectNode().put("name", entity.name);
        }

        public Foo decode(ObjectNode json, CodecContext context) {
            return new Foo(json.get("name").asText());
        }
    }

    private static class Foo {
        final String name;

        Foo(String name) {
            this.name = name;
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Foo other = (Foo)obj;
            return Objects.equals(this.name, other.name);
        }
    }
}

