/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.testing.EqualsTester;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;

public class DefaultLinkTest {
    private static final ProviderId PID = new ProviderId("of", "foo");
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:foo");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:bar");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);

    public static ConnectPoint cp(ElementId id, PortNumber pn) {
        return new ConnectPoint(id, pn);
    }

    @Test
    public void testEquality() {
        DefaultLink l1 = new DefaultLink(PID, DefaultLinkTest.cp((ElementId)DID1, P1), DefaultLinkTest.cp((ElementId)DID2, P2), Link.Type.DIRECT, new Annotations[0]);
        DefaultLink l2 = new DefaultLink(PID, DefaultLinkTest.cp((ElementId)DID1, P1), DefaultLinkTest.cp((ElementId)DID2, P2), Link.Type.DIRECT, new Annotations[0]);
        DefaultLink l3 = new DefaultLink(PID, DefaultLinkTest.cp((ElementId)DID1, P2), DefaultLinkTest.cp((ElementId)DID2, P2), Link.Type.DIRECT, new Annotations[0]);
        DefaultLink l4 = new DefaultLink(PID, DefaultLinkTest.cp((ElementId)DID1, P2), DefaultLinkTest.cp((ElementId)DID2, P2), Link.Type.DIRECT, new Annotations[0]);
        DefaultLink l5 = new DefaultLink(PID, DefaultLinkTest.cp((ElementId)DID1, P2), DefaultLinkTest.cp((ElementId)DID2, P2), Link.Type.INDIRECT, new Annotations[0]);
        new EqualsTester().addEqualityGroup(new Object[]{l1, l2}).addEqualityGroup(new Object[]{l3, l4}).addEqualityGroup(new Object[]{l5}).testEquals();
    }

    @Test
    public void basics() {
        DefaultLink link = new DefaultLink(PID, DefaultLinkTest.cp((ElementId)DID1, P1), DefaultLinkTest.cp((ElementId)DID2, P2), Link.Type.DIRECT, new Annotations[0]);
        Assert.assertEquals((String)"incorrect src", (Object)DefaultLinkTest.cp((ElementId)DID1, P1), (Object)link.src());
        Assert.assertEquals((String)"incorrect dst", (Object)DefaultLinkTest.cp((ElementId)DID2, P2), (Object)link.dst());
        Assert.assertEquals((String)"incorrect type", (Object)Link.Type.DIRECT, (Object)link.type());
    }
}

