/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.testing.EqualsTester;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.IntentTestsMocks;

public class DefaultFlowEntryTest {
    private static final IntentTestsMocks.MockSelector SELECTOR = new IntentTestsMocks.MockSelector();
    private static final IntentTestsMocks.MockTreatment TREATMENT = new IntentTestsMocks.MockTreatment();
    final DefaultFlowEntry defaultFlowEntry1 = DefaultFlowEntryTest.makeFlowEntry(1);
    final DefaultFlowEntry sameAsDefaultFlowEntry1 = DefaultFlowEntryTest.makeFlowEntry(1);
    final DefaultFlowEntry defaultFlowEntry2 = DefaultFlowEntryTest.makeFlowEntry(2);

    private static DefaultFlowEntry makeFlowEntry(int uniqueValue) {
        return new DefaultFlowEntry(NetTestTools.did("id" + Integer.toString(uniqueValue)), (TrafficSelector)SELECTOR, (TrafficTreatment)TREATMENT, uniqueValue, FlowEntry.FlowEntryState.ADDED, (long)uniqueValue, (long)uniqueValue, (long)uniqueValue, (long)uniqueValue, uniqueValue);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.defaultFlowEntry1, this.sameAsDefaultFlowEntry1}).addEqualityGroup(new Object[]{this.defaultFlowEntry2}).testEquals();
    }

    @Test
    public void testDeviceBasedObject() {
        MatcherAssert.assertThat((Object)this.defaultFlowEntry1.deviceId(), (Matcher)Matchers.is((Object)NetTestTools.did("id1")));
        MatcherAssert.assertThat((Object)this.defaultFlowEntry1.selector(), (Matcher)Matchers.is((Object)SELECTOR));
        MatcherAssert.assertThat((Object)this.defaultFlowEntry1.treatment(), (Matcher)Matchers.is((Object)TREATMENT));
        MatcherAssert.assertThat((Object)this.defaultFlowEntry1.timeout(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.defaultFlowEntry1.life(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)this.defaultFlowEntry1.packets(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)this.defaultFlowEntry1.bytes(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)this.defaultFlowEntry1.state(), (Matcher)Matchers.is((Object)FlowEntry.FlowEntryState.ADDED));
        MatcherAssert.assertThat((Object)this.defaultFlowEntry1.lastSeen(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS))));
    }

    @Test
    public void testSetters() {
        DefaultFlowEntry entry = DefaultFlowEntryTest.makeFlowEntry(1);
        entry.setLastSeen();
        entry.setState(FlowEntry.FlowEntryState.PENDING_REMOVE);
        entry.setPackets(11L);
        entry.setBytes(22L);
        entry.setLife(33L);
        MatcherAssert.assertThat((Object)entry.deviceId(), (Matcher)Matchers.is((Object)NetTestTools.did("id1")));
        MatcherAssert.assertThat((Object)entry.selector(), (Matcher)Matchers.is((Object)SELECTOR));
        MatcherAssert.assertThat((Object)entry.treatment(), (Matcher)Matchers.is((Object)TREATMENT));
        MatcherAssert.assertThat((Object)entry.timeout(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)entry.life(), (Matcher)Matchers.is((Object)33L));
        MatcherAssert.assertThat((Object)entry.packets(), (Matcher)Matchers.is((Object)11L));
        MatcherAssert.assertThat((Object)entry.bytes(), (Matcher)Matchers.is((Object)22L));
        MatcherAssert.assertThat((Object)entry.state(), (Matcher)Matchers.is((Object)FlowEntry.FlowEntryState.PENDING_REMOVE));
        MatcherAssert.assertThat((Object)entry.lastSeen(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS))));
    }

    @Test
    public void testErrorObject() {
        DefaultFlowEntry errorEntry = new DefaultFlowEntry((FlowRule)new IntentTestsMocks.MockFlowRule(1), 111, 222);
        MatcherAssert.assertThat((Object)errorEntry.errType(), (Matcher)Matchers.is((Object)111));
        MatcherAssert.assertThat((Object)errorEntry.errCode(), (Matcher)Matchers.is((Object)222));
        MatcherAssert.assertThat((Object)errorEntry.state(), (Matcher)Matchers.is((Object)FlowEntry.FlowEntryState.FAILED));
        MatcherAssert.assertThat((Object)errorEntry.lastSeen(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS))));
    }

    @Test
    public void testFlowBasedObject() {
        DefaultFlowEntry entry = new DefaultFlowEntry((FlowRule)new IntentTestsMocks.MockFlowRule(1));
        MatcherAssert.assertThat((Object)entry.priority(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)entry.appId(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)entry.lastSeen(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS))));
    }

    @Test
    public void testFlowBasedObjectWithParameters() {
        DefaultFlowEntry entry = new DefaultFlowEntry((FlowRule)new IntentTestsMocks.MockFlowRule(33), FlowEntry.FlowEntryState.REMOVED, 101L, 102L, 103L);
        MatcherAssert.assertThat((Object)entry.state(), (Matcher)Matchers.is((Object)FlowEntry.FlowEntryState.REMOVED));
        MatcherAssert.assertThat((Object)entry.life(), (Matcher)Matchers.is((Object)101L));
        MatcherAssert.assertThat((Object)entry.packets(), (Matcher)Matchers.is((Object)102L));
        MatcherAssert.assertThat((Object)entry.bytes(), (Matcher)Matchers.is((Object)103L));
        MatcherAssert.assertThat((Object)entry.lastSeen(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS))));
    }
}

