/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.testing.EqualsTester;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;

public class DefaultTrafficSelectorTest {
    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultTrafficSelector.class);
    }

    @Test
    public void testEquals() {
        boolean one = true;
        int two = 2;
        TrafficSelector selector1 = DefaultTrafficSelector.builder().matchLambda(Short.valueOf((short)1)).build();
        TrafficSelector sameAsSelector1 = DefaultTrafficSelector.builder().matchLambda(Short.valueOf((short)1)).build();
        TrafficSelector selector2 = DefaultTrafficSelector.builder().matchLambda(Short.valueOf((short)2)).build();
        new EqualsTester().addEqualityGroup(new Object[]{selector1, sameAsSelector1}).addEqualityGroup(new Object[]{selector2}).testEquals();
    }

    @Factory
    public static Matcher<TrafficSelector> hasCriterionWithType(Criterion.Type type) {
        return new CriterionExistsMatcher(type);
    }

    @Test
    public void testCriteriaCreation() {
        int shortValue = 33;
        int byteValue = 44;
        IpPrefix ipPrefixValue = IpPrefix.valueOf((String)"192.168.1.0/24");
        TrafficSelector selector = DefaultTrafficSelector.builder().matchInport(PortNumber.portNumber((long)11L)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IN_PORT));
        selector = DefaultTrafficSelector.builder().matchEthSrc(MacAddress.BROADCAST).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ETH_SRC));
        selector = DefaultTrafficSelector.builder().matchEthDst(MacAddress.BROADCAST).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ETH_DST));
        selector = DefaultTrafficSelector.builder().matchEthType((short)33).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.ETH_TYPE));
        selector = DefaultTrafficSelector.builder().matchVlanId(VlanId.vlanId((short)33)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.VLAN_VID));
        selector = DefaultTrafficSelector.builder().matchVlanPcp(Byte.valueOf((byte)44)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.VLAN_PCP));
        selector = DefaultTrafficSelector.builder().matchIPProtocol(Byte.valueOf((byte)44)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IP_PROTO));
        selector = DefaultTrafficSelector.builder().matchIPSrc(ipPrefixValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV4_SRC));
        selector = DefaultTrafficSelector.builder().matchIPDst(ipPrefixValue).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.IPV4_DST));
        selector = DefaultTrafficSelector.builder().matchTcpSrc(Short.valueOf((short)33)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.TCP_SRC));
        selector = DefaultTrafficSelector.builder().matchTcpDst(Short.valueOf((short)33)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.TCP_DST));
        selector = DefaultTrafficSelector.builder().matchMplsLabel(Integer.valueOf(3)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.MPLS_LABEL));
        selector = DefaultTrafficSelector.builder().matchLambda(Short.valueOf((short)33)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.OCH_SIGID));
        selector = DefaultTrafficSelector.builder().matchOpticalSignalType(Short.valueOf((short)33)).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.OCH_SIGTYPE));
        TrafficSelector baseSelector = DefaultTrafficSelector.builder().matchOpticalSignalType(Short.valueOf((short)33)).build();
        selector = DefaultTrafficSelector.builder((TrafficSelector)baseSelector).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.OCH_SIGTYPE));
        Criterion criterion = Criteria.matchLambda((Short)33);
        selector = DefaultTrafficSelector.builder().add(criterion).build();
        MatcherAssert.assertThat((Object)selector, DefaultTrafficSelectorTest.hasCriterionWithType(Criterion.Type.OCH_SIGID));
    }

    public static final class CriterionExistsMatcher
    extends TypeSafeMatcher<TrafficSelector> {
        private final Criterion.Type type;

        public CriterionExistsMatcher(Criterion.Type typeValue) {
            this.type = typeValue;
        }

        public boolean matchesSafely(TrafficSelector selector) {
            Set criteria = selector.criteria();
            return Matchers.notNullValue().matches((Object)criteria) && Matchers.hasSize((int)1).matches((Object)criteria) && Matchers.notNullValue().matches((Object)selector.getCriterion(this.type));
        }

        public void describeTo(Description description) {
            description.appendText("a criterion with type \" ").appendText(this.type.toString()).appendText("\"");
        }
    }
}

