/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.junit.UtilityClassChecker;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;

public class CriteriaTest {
    final PortNumber port1 = PortNumber.portNumber((long)1L);
    final PortNumber port2 = PortNumber.portNumber((long)2L);
    Criterion matchInPort1 = Criteria.matchInPort((PortNumber)this.port1);
    Criterion sameAsMatchInPort1 = Criteria.matchInPort((PortNumber)this.port1);
    Criterion matchInPort2 = Criteria.matchInPort((PortNumber)this.port2);
    Criterion matchTcpPort1 = Criteria.matchTcpSrc((Short)1);
    Criterion sameAsMatchTcpPort1 = Criteria.matchTcpSrc((Short)1);
    Criterion matchTcpPort2 = Criteria.matchTcpDst((Short)2);
    private static final String MAC1 = "00:00:00:00:00:01";
    private static final String MAC2 = "00:00:00:00:00:02";
    private MacAddress mac1 = new MacAddress("00:00:00:00:00:01".getBytes());
    private MacAddress mac2 = new MacAddress("00:00:00:00:00:02".getBytes());
    Criterion matchEth1 = Criteria.matchEthSrc((MacAddress)this.mac1);
    Criterion sameAsMatchEth1 = Criteria.matchEthSrc((MacAddress)this.mac1);
    Criterion matchEth2 = Criteria.matchEthDst((MacAddress)this.mac2);
    short ethType1 = 1;
    short ethType2 = (short)2;
    Criterion matchEthType1 = Criteria.matchEthType((Short)this.ethType1);
    Criterion sameAsMatchEthType1 = Criteria.matchEthType((Short)this.ethType1);
    Criterion matchEthType2 = Criteria.matchEthType((Short)this.ethType2);
    short vlan1 = 1;
    short vlan2 = (short)2;
    VlanId vlanId1 = VlanId.vlanId((short)this.vlan1);
    VlanId vlanId2 = VlanId.vlanId((short)this.vlan2);
    Criterion matchVlanId1 = Criteria.matchVlanId((VlanId)this.vlanId1);
    Criterion sameAsMatchVlanId1 = Criteria.matchVlanId((VlanId)this.vlanId1);
    Criterion matchVlanId2 = Criteria.matchVlanId((VlanId)this.vlanId2);
    byte vlanPcp1 = 1;
    byte vlanPcp2 = (byte)2;
    Criterion matchVlanPcp1 = Criteria.matchVlanPcp((Byte)this.vlanPcp1);
    Criterion sameAsMatchVlanPcp1 = Criteria.matchVlanPcp((Byte)this.vlanPcp1);
    Criterion matchVlanPcp2 = Criteria.matchVlanPcp((Byte)this.vlanPcp2);
    byte protocol1 = 1;
    byte protocol2 = (byte)2;
    Criterion matchIpProtocol1 = Criteria.matchIPProtocol((Byte)this.protocol1);
    Criterion sameAsMatchIpProtocol1 = Criteria.matchIPProtocol((Byte)this.protocol1);
    Criterion matchIpProtocol2 = Criteria.matchIPProtocol((Byte)this.protocol2);
    private static final String IP1 = "1.2.3.4/24";
    private static final String IP2 = "5.6.7.8/24";
    private IpPrefix ip1 = IpPrefix.valueOf((String)"1.2.3.4/24");
    private IpPrefix ip2 = IpPrefix.valueOf((String)"5.6.7.8/24");
    Criterion matchIp1 = Criteria.matchIPSrc((IpPrefix)this.ip1);
    Criterion sameAsMatchIp1 = Criteria.matchIPSrc((IpPrefix)this.ip1);
    Criterion matchIp2 = Criteria.matchIPSrc((IpPrefix)this.ip2);
    short lambda1 = 1;
    short lambda2 = (short)2;
    Criterion matchLambda1 = Criteria.matchLambda((Short)this.lambda1);
    Criterion sameAsMatchLambda1 = Criteria.matchLambda((Short)this.lambda1);
    Criterion matchLambda2 = Criteria.matchLambda((Short)this.lambda2);
    short signalLambda1 = 1;
    short signalLambda2 = (short)2;
    Criterion matchSignalLambda1 = Criteria.matchOpticalSignalType((Short)this.signalLambda1);
    Criterion sameAsMatchSignalLambda1 = Criteria.matchOpticalSignalType((Short)this.signalLambda1);
    Criterion matchSignalLambda2 = Criteria.matchOpticalSignalType((Short)this.signalLambda2);

    private <T> T checkAndConvert(Criterion criterion, Criterion.Type type, Class clazz) {
        MatcherAssert.assertThat((Object)criterion, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)criterion.type(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)type)));
        MatcherAssert.assertThat((Object)criterion, (Matcher)Matchers.instanceOf((Class)clazz));
        return (T)criterion;
    }

    @Test
    public void testCriteriaUtility() {
        UtilityClassChecker.assertThatClassIsUtility(Criteria.class);
    }

    @Test
    public void testCriteriaImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.PortCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.EthCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.EthTypeCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.IPCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.IPProtocolCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.VlanPcpCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.VlanIdCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.TcpPortCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.LambdaCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.OpticalSignalTypeCriterion.class);
    }

    @Test
    public void testMatchInPortMethod() {
        PortNumber p1 = PortNumber.portNumber((long)1L);
        Criterion matchInPort = Criteria.matchInPort((PortNumber)p1);
        Criteria.PortCriterion portCriterion = (Criteria.PortCriterion)this.checkAndConvert(matchInPort, Criterion.Type.IN_PORT, Criteria.PortCriterion.class);
        MatcherAssert.assertThat((Object)portCriterion.port(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)p1)));
    }

    @Test
    public void testPortCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchInPort1, this.sameAsMatchInPort1}).addEqualityGroup(new Object[]{this.matchInPort2}).testEquals();
    }

    @Test
    public void testMatchEthSrcMethod() {
        Criterion matchEthSrc = Criteria.matchEthSrc((MacAddress)this.mac1);
        Criteria.EthCriterion ethCriterion = (Criteria.EthCriterion)this.checkAndConvert(matchEthSrc, Criterion.Type.ETH_SRC, Criteria.EthCriterion.class);
        MatcherAssert.assertThat((Object)ethCriterion.mac(), (Matcher)Matchers.is((Object)this.mac1));
    }

    @Test
    public void testMatchEthDstMethod() {
        Criterion matchTcpDst = Criteria.matchEthDst((MacAddress)this.mac1);
        Criteria.EthCriterion ethCriterion = (Criteria.EthCriterion)this.checkAndConvert(matchTcpDst, Criterion.Type.ETH_DST, Criteria.EthCriterion.class);
        MatcherAssert.assertThat((Object)ethCriterion.mac(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.mac1)));
    }

    @Test
    public void testEthCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchEth1, this.sameAsMatchEth1}).addEqualityGroup(new Object[]{this.matchEth2}).testEquals();
    }

    @Test
    public void testMatchTcpSrcMethod() {
        Criterion matchTcpSrc = Criteria.matchTcpSrc((Short)1);
        Criteria.TcpPortCriterion tcpPortCriterion = (Criteria.TcpPortCriterion)this.checkAndConvert(matchTcpSrc, Criterion.Type.TCP_SRC, Criteria.TcpPortCriterion.class);
        MatcherAssert.assertThat((Object)tcpPortCriterion.tcpPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void testMatchTcpDstMethod() {
        Criterion matchTcpDst = Criteria.matchTcpDst((Short)1);
        Criteria.TcpPortCriterion tcpPortCriterion = (Criteria.TcpPortCriterion)this.checkAndConvert(matchTcpDst, Criterion.Type.TCP_DST, Criteria.TcpPortCriterion.class);
        MatcherAssert.assertThat((Object)tcpPortCriterion.tcpPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void testTcpPortCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchTcpPort1, this.sameAsMatchTcpPort1}).addEqualityGroup(new Object[]{this.matchTcpPort2}).testEquals();
    }

    @Test
    public void testMatchEthTypeMethod() {
        Short ethType = 12;
        Criterion matchEthType = Criteria.matchEthType((Short)ethType);
        Criteria.EthTypeCriterion ethTypeCriterion = (Criteria.EthTypeCriterion)this.checkAndConvert(matchEthType, Criterion.Type.ETH_TYPE, Criteria.EthTypeCriterion.class);
        MatcherAssert.assertThat((Object)ethTypeCriterion.ethType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ethType)));
    }

    @Test
    public void testEthTypeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchEthType1, this.sameAsMatchEthType1}).addEqualityGroup(new Object[]{this.matchEthType2}).testEquals();
    }

    @Test
    public void testMatchVlanIdMethod() {
        Criterion matchVlanId = Criteria.matchVlanId((VlanId)this.vlanId1);
        Criteria.VlanIdCriterion vlanIdCriterion = (Criteria.VlanIdCriterion)this.checkAndConvert(matchVlanId, Criterion.Type.VLAN_VID, Criteria.VlanIdCriterion.class);
        MatcherAssert.assertThat((Object)vlanIdCriterion.vlanId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.vlanId1)));
    }

    @Test
    public void testVlanIdCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchVlanId1, this.sameAsMatchVlanId1}).addEqualityGroup(new Object[]{this.matchVlanId2}).testEquals();
    }

    @Test
    public void testMatchVlanPcpMethod() {
        Criterion matchVlanPcp = Criteria.matchVlanPcp((Byte)this.vlanPcp1);
        Criteria.VlanPcpCriterion vlanPcpCriterion = (Criteria.VlanPcpCriterion)this.checkAndConvert(matchVlanPcp, Criterion.Type.VLAN_PCP, Criteria.VlanPcpCriterion.class);
        MatcherAssert.assertThat((Object)vlanPcpCriterion.priority(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.vlanPcp1)));
    }

    @Test
    public void testVlanPcpCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchVlanPcp1, this.sameAsMatchVlanPcp1}).addEqualityGroup(new Object[]{this.matchVlanPcp2}).testEquals();
    }

    @Test
    public void testMatchIpProtocolMethod() {
        Criterion matchIPProtocol = Criteria.matchIPProtocol((Byte)this.protocol1);
        Criteria.IPProtocolCriterion ipProtocolCriterion = (Criteria.IPProtocolCriterion)this.checkAndConvert(matchIPProtocol, Criterion.Type.IP_PROTO, Criteria.IPProtocolCriterion.class);
        MatcherAssert.assertThat((Object)ipProtocolCriterion.protocol(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.protocol1)));
    }

    @Test
    public void testIpProtocolCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIpProtocol1, this.sameAsMatchIpProtocol1}).addEqualityGroup(new Object[]{this.matchIpProtocol2}).testEquals();
    }

    @Test
    public void testMatchIPSrcMethod() {
        Criterion matchIpSrc = Criteria.matchIPSrc((IpPrefix)this.ip1);
        Criteria.IPCriterion ipCriterion = (Criteria.IPCriterion)this.checkAndConvert(matchIpSrc, Criterion.Type.IPV4_SRC, Criteria.IPCriterion.class);
        MatcherAssert.assertThat((Object)ipCriterion.ip(), (Matcher)Matchers.is((Object)this.ip1));
    }

    @Test
    public void testMatchIPDstMethod() {
        Criterion matchIPDst = Criteria.matchIPDst((IpPrefix)this.ip1);
        Criteria.IPCriterion ipCriterion = (Criteria.IPCriterion)this.checkAndConvert(matchIPDst, Criterion.Type.IPV4_DST, Criteria.IPCriterion.class);
        MatcherAssert.assertThat((Object)ipCriterion.ip(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ip1)));
    }

    @Test
    public void testIPCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIp1, this.sameAsMatchIp1}).addEqualityGroup(new Object[]{this.matchIp2}).testEquals();
    }

    @Test
    public void testMatchLambdaMethod() {
        Criterion matchLambda = Criteria.matchLambda((Short)this.lambda1);
        Criteria.LambdaCriterion lambdaCriterion = (Criteria.LambdaCriterion)this.checkAndConvert(matchLambda, Criterion.Type.OCH_SIGID, Criteria.LambdaCriterion.class);
        MatcherAssert.assertThat((Object)lambdaCriterion.lambda(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.lambda1)));
    }

    @Test
    public void testLambdaCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchLambda1, this.sameAsMatchLambda1}).addEqualityGroup(new Object[]{this.matchLambda2}).testEquals();
    }

    @Test
    public void testMatchOpticalSignalTypeMethod() {
        Criterion matchLambda = Criteria.matchOpticalSignalType((Short)this.signalLambda1);
        Criteria.OpticalSignalTypeCriterion opticalSignalTypeCriterion = (Criteria.OpticalSignalTypeCriterion)this.checkAndConvert(matchLambda, Criterion.Type.OCH_SIGTYPE, Criteria.OpticalSignalTypeCriterion.class);
        MatcherAssert.assertThat((Object)opticalSignalTypeCriterion.signalType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.signalLambda1)));
    }

    @Test
    public void testOpticalSignalTypeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchSignalLambda1, this.sameAsMatchSignalLambda1}).addEqualityGroup(new Object[]{this.matchSignalLambda2}).testEquals();
    }
}

