/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.topology;

import com.google.common.collect.ImmutableSet;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.topology.DefaultGraphDescription;
import org.onosproject.net.topology.DefaultTopologyEdge;
import org.onosproject.net.topology.DefaultTopologyEdgeTest;
import org.onosproject.net.topology.TopologyVertex;

public class DefaultGraphDescriptionTest {
    static final DefaultTopologyEdge E1 = new DefaultTopologyEdge((TopologyVertex)DefaultTopologyEdgeTest.V1, (TopologyVertex)DefaultTopologyEdgeTest.V2, DefaultTopologyEdgeTest.L1);
    static final DefaultTopologyEdge E2 = new DefaultTopologyEdge((TopologyVertex)DefaultTopologyEdgeTest.V1, (TopologyVertex)DefaultTopologyEdgeTest.V2, DefaultTopologyEdgeTest.L1);
    private static final DeviceId D3 = DeviceId.deviceId((String)"3");
    static final Device DEV1 = new DefaultDevice(DefaultTopologyEdgeTest.PID, DefaultTopologyEdgeTest.D1, Device.Type.SWITCH, "", "", "", "", null, new Annotations[0]);
    static final Device DEV2 = new DefaultDevice(DefaultTopologyEdgeTest.PID, DefaultTopologyEdgeTest.D2, Device.Type.SWITCH, "", "", "", "", null, new Annotations[0]);
    static final Device DEV3 = new DefaultDevice(DefaultTopologyEdgeTest.PID, D3, Device.Type.SWITCH, "", "", "", "", null, new Annotations[0]);

    @Test
    public void basics() {
        DefaultGraphDescription desc = new DefaultGraphDescription(4321L, (Iterable)ImmutableSet.of((Object)DEV1, (Object)DEV2, (Object)DEV3), (Iterable)ImmutableSet.of((Object)DefaultTopologyEdgeTest.L1, (Object)DefaultTopologyEdgeTest.L2), new SparseAnnotations[0]);
        Assert.assertEquals((String)"incorrect time", (long)4321L, (long)desc.timestamp());
        Assert.assertEquals((String)"incorrect vertex count", (long)3L, (long)desc.vertexes().size());
        Assert.assertEquals((String)"incorrect edge count", (long)2L, (long)desc.edges().size());
    }

    @Test
    public void missingVertex() {
        DefaultGraphDescription desc = new DefaultGraphDescription(4321L, (Iterable)ImmutableSet.of((Object)DEV1, (Object)DEV3), (Iterable)ImmutableSet.of((Object)DefaultTopologyEdgeTest.L1, (Object)DefaultTopologyEdgeTest.L2), new SparseAnnotations[0]);
        Assert.assertEquals((String)"incorrect time", (long)4321L, (long)desc.timestamp());
        Assert.assertEquals((String)"incorrect vertex count", (long)2L, (long)desc.vertexes().size());
        Assert.assertEquals((String)"incorrect edge count", (long)0L, (long)desc.edges().size());
    }
}

