/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.topology;

import com.google.common.testing.EqualsTester;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.DeviceId;
import org.onosproject.net.topology.ClusterId;
import org.onosproject.net.topology.DefaultTopologyCluster;
import org.onosproject.net.topology.TopologyCluster;

public class DefaultTopologyClusterTest {
    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.cluster(3, 2, 1, "of:1"), this.cluster(3, 2, 1, "of:1")}).addEqualityGroup(new Object[]{this.cluster(3, 2, 1, "of:2"), this.cluster(3, 2, 1, "of:2")}).addEqualityGroup(new Object[]{this.cluster(0, 2, 1, "of:1"), this.cluster(0, 2, 1, "of:1")}).addEqualityGroup(new Object[]{this.cluster(3, 3, 1, "of:1"), this.cluster(3, 3, 1, "of:1")}).testEquals();
    }

    @Test
    public void basics() {
        TopologyCluster cluster = this.cluster(6, 5, 4, "of:111");
        Assert.assertEquals((String)"incorrect id", (Object)ClusterId.clusterId((int)6), (Object)cluster.id());
        Assert.assertEquals((String)"incorrect id", (long)5L, (long)cluster.deviceCount());
        Assert.assertEquals((String)"incorrect id", (long)4L, (long)cluster.linkCount());
        Assert.assertEquals((String)"incorrect id", (Object)DeviceId.deviceId((String)"of:111"), (Object)cluster.root());
    }

    private TopologyCluster cluster(int id, int dc, int lc, String root) {
        return new DefaultTopologyCluster(ClusterId.clusterId((int)id), dc, lc, DeviceId.deviceId((String)root));
    }
}

