/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.event;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractListenerRegistry<E extends Event, L extends EventListener<E>>
implements EventSink<E> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<L> listeners = new CopyOnWriteArraySet<L>();
    private volatile boolean shutdown = false;

    public void addListener(L listener) {
        Preconditions.checkNotNull(listener, (Object)"Listener cannot be null");
        this.listeners.add(listener);
    }

    public void removeListener(L listener) {
        Preconditions.checkNotNull(listener, (Object)"Listener cannot be null");
        Preconditions.checkArgument((boolean)this.listeners.remove(listener), (Object)"Listener not registered");
    }

    @Override
    public void process(E event) {
        for (EventListener listener : this.listeners) {
            try {
                listener.event(event);
            }
            catch (Exception error) {
                this.reportProblem(event, error);
            }
        }
    }

    protected void reportProblem(E event, Throwable error) {
        if (!this.shutdown) {
            this.log.warn("Exception encountered while processing event " + event, error);
        }
    }

    public void activate() {
        this.shutdown = false;
    }

    public void deactivate() {
        this.shutdown = true;
    }
}

