/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;

public class DefaultFlowRule
implements FlowRule {
    private final DeviceId deviceId;
    private final int priority;
    private final TrafficSelector selector;
    private final TrafficTreatment treatment;
    private final long created;
    private final FlowId id;
    private final short appId;
    private final int timeout;
    private final boolean permanent;
    private final GroupId groupId;

    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, long flowId, int timeout, boolean permanent) {
        this.deviceId = deviceId;
        this.priority = priority;
        this.selector = selector;
        this.treatment = treatment;
        this.timeout = timeout;
        this.permanent = permanent;
        this.created = System.currentTimeMillis();
        this.appId = (short)(flowId >>> 48);
        this.groupId = new DefaultGroupId((short)(flowId >>> 32 & 0xFFFFL));
        this.id = FlowId.valueOf(flowId);
    }

    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, ApplicationId appId, int timeout, boolean permanent) {
        this(deviceId, selector, treatment, priority, appId, new DefaultGroupId(0), timeout, permanent);
    }

    @Deprecated
    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, ApplicationId appId, short groupId, int timeout, boolean permanent) {
        this(deviceId, selector, treatment, priority, appId, new DefaultGroupId(groupId), timeout, permanent);
    }

    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, ApplicationId appId, GroupId groupId, int timeout, boolean permanent) {
        if (priority < 0) {
            throw new IllegalArgumentException("Priority cannot be less than 0");
        }
        this.deviceId = deviceId;
        this.priority = priority;
        this.selector = selector;
        this.treatment = treatment;
        this.appId = appId.id();
        this.groupId = groupId;
        this.timeout = timeout;
        this.permanent = permanent;
        this.created = System.currentTimeMillis();
        this.id = FlowId.valueOf((long)this.appId << 48 | (long)this.groupId.id() << 32 | (long)this.hash() & 0xFFFFFFFFL);
    }

    public DefaultFlowRule(FlowRule rule) {
        this.deviceId = rule.deviceId();
        this.priority = rule.priority();
        this.selector = rule.selector();
        this.treatment = rule.treatment();
        this.appId = rule.appId();
        this.groupId = rule.groupId();
        this.id = rule.id();
        this.timeout = rule.timeout();
        this.permanent = rule.isPermanent();
        this.created = System.currentTimeMillis();
    }

    @Override
    public FlowId id() {
        return this.id;
    }

    @Override
    public short appId() {
        return this.appId;
    }

    @Override
    public GroupId groupId() {
        return this.groupId;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public TrafficSelector selector() {
        return this.selector;
    }

    @Override
    public TrafficTreatment treatment() {
        return this.treatment;
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.selector, this.priority);
    }

    public int hash() {
        return Objects.hash(this.deviceId, this.selector, this.treatment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultFlowRule) {
            DefaultFlowRule that = (DefaultFlowRule)obj;
            return Objects.equals(this.deviceId, that.deviceId) && Objects.equals(this.priority, that.priority) && Objects.equals(this.selector, that.selector);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)Long.toHexString(this.id.value())).add("deviceId", (Object)this.deviceId).add("priority", this.priority).add("selector", this.selector.criteria()).add("treatment", this.treatment == null ? "N/A" : this.treatment.instructions()).add("created", this.created).toString();
    }

    @Override
    public int timeout() {
        return this.timeout;
    }

    @Override
    public boolean isPermanent() {
        return this.permanent;
    }
}

