/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchOperation;

public class FlowRuleBatchRequest {
    private final int batchId;
    private final List<FlowRuleBatchEntry> toAdd;
    private final List<FlowRuleBatchEntry> toRemove;

    public FlowRuleBatchRequest(int batchId, List<FlowRuleBatchEntry> toAdd, List<FlowRuleBatchEntry> toRemove) {
        this.batchId = batchId;
        this.toAdd = Collections.unmodifiableList(toAdd);
        this.toRemove = Collections.unmodifiableList(toRemove);
    }

    public List<FlowRule> toAdd() {
        return FluentIterable.from(this.toAdd).transform((Function)new Function<FlowRuleBatchEntry, FlowRule>(){

            public FlowRule apply(FlowRuleBatchEntry input) {
                return (FlowRule)input.getTarget();
            }
        }).toList();
    }

    public List<FlowRule> toRemove() {
        return FluentIterable.from(this.toRemove).transform((Function)new Function<FlowRuleBatchEntry, FlowRule>(){

            public FlowRule apply(FlowRuleBatchEntry input) {
                return (FlowRule)input.getTarget();
            }
        }).toList();
    }

    public FlowRuleBatchOperation asBatchOperation() {
        ArrayList entries = Lists.newArrayList();
        entries.addAll(this.toAdd);
        entries.addAll(this.toRemove);
        return new FlowRuleBatchOperation(entries);
    }

    public int batchId() {
        return this.batchId;
    }
}

