/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.criteria.Criterion;

public final class Criteria {
    private Criteria() {
    }

    public static Criterion matchInPort(PortNumber port) {
        return new PortCriterion(port);
    }

    public static Criterion matchEthSrc(MacAddress mac) {
        return new EthCriterion(mac, Criterion.Type.ETH_SRC);
    }

    public static Criterion matchEthDst(MacAddress mac) {
        return new EthCriterion(mac, Criterion.Type.ETH_DST);
    }

    public static Criterion matchEthType(Short ethType) {
        return new EthTypeCriterion(ethType);
    }

    public static Criterion matchVlanId(VlanId vlanId) {
        return new VlanIdCriterion(vlanId);
    }

    public static Criterion matchVlanPcp(Byte vlanPcp) {
        return new VlanPcpCriterion(vlanPcp);
    }

    public static Criterion matchIPProtocol(Byte proto) {
        return new IPProtocolCriterion(proto);
    }

    public static Criterion matchIPSrc(IpPrefix ip) {
        return new IPCriterion(ip, Criterion.Type.IPV4_SRC);
    }

    public static Criterion matchIPDst(IpPrefix ip) {
        return new IPCriterion(ip, Criterion.Type.IPV4_DST);
    }

    public static Criterion matchTcpSrc(Short tcpPort) {
        return new TcpPortCriterion(tcpPort, Criterion.Type.TCP_SRC);
    }

    public static Criterion matchTcpDst(Short tcpPort) {
        return new TcpPortCriterion(tcpPort, Criterion.Type.TCP_DST);
    }

    public static Criterion matchMplsLabel(Integer mplsLabel) {
        return new MplsCriterion(mplsLabel);
    }

    public static Criterion matchLambda(Short lambda) {
        return new LambdaCriterion(lambda, Criterion.Type.OCH_SIGID);
    }

    public static Criterion matchOpticalSignalType(Short sigType) {
        return new OpticalSignalTypeCriterion(sigType, Criterion.Type.OCH_SIGTYPE);
    }

    public static final class OpticalSignalTypeCriterion
    implements Criterion {
        private final Short signalType;
        private final Criterion.Type type;

        public OpticalSignalTypeCriterion(Short signalType, Criterion.Type type) {
            this.signalType = signalType;
            this.type = type;
        }

        @Override
        public Criterion.Type type() {
            return this.type;
        }

        public Short signalType() {
            return this.signalType;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.type().toString()).add("signalType", (Object)this.signalType).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.signalType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OpticalSignalTypeCriterion) {
                OpticalSignalTypeCriterion that = (OpticalSignalTypeCriterion)obj;
                return Objects.equals(this.signalType, that.signalType) && Objects.equals((Object)this.type, (Object)that.type);
            }
            return false;
        }
    }

    public static final class LambdaCriterion
    implements Criterion {
        private final short lambda;
        private final Criterion.Type type;

        public LambdaCriterion(short lambda, Criterion.Type type) {
            this.lambda = lambda;
            this.type = type;
        }

        @Override
        public Criterion.Type type() {
            return this.type;
        }

        public Short lambda() {
            return this.lambda;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.type().toString()).add("lambda", (int)this.lambda).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.lambda});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof LambdaCriterion) {
                LambdaCriterion that = (LambdaCriterion)obj;
                return Objects.equals(this.lambda, that.lambda) && Objects.equals((Object)this.type, (Object)that.type);
            }
            return false;
        }
    }

    public static final class MplsCriterion
    implements Criterion {
        private final Integer mplsLabel;

        public MplsCriterion(Integer mplsLabel) {
            this.mplsLabel = mplsLabel;
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.MPLS_LABEL;
        }

        public Integer label() {
            return this.mplsLabel;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.type().toString()).add("mpls", this.mplsLabel.intValue()).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mplsLabel, this.type()});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof MplsCriterion) {
                MplsCriterion that = (MplsCriterion)obj;
                return Objects.equals(this.mplsLabel, that.mplsLabel) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class TcpPortCriterion
    implements Criterion {
        private final Short tcpPort;
        private final Criterion.Type type;

        public TcpPortCriterion(Short tcpPort, Criterion.Type type) {
            this.tcpPort = tcpPort;
            this.type = type;
        }

        @Override
        public Criterion.Type type() {
            return this.type;
        }

        public Short tcpPort() {
            return this.tcpPort;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.type().toString()).add("tcpPort", (Object)this.tcpPort).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.tcpPort});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TcpPortCriterion) {
                TcpPortCriterion that = (TcpPortCriterion)obj;
                return Objects.equals(this.tcpPort, that.tcpPort) && Objects.equals((Object)this.type, (Object)that.type);
            }
            return false;
        }
    }

    public static final class VlanIdCriterion
    implements Criterion {
        private final VlanId vlanId;

        public VlanIdCriterion(VlanId vlanId) {
            this.vlanId = vlanId;
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.VLAN_VID;
        }

        public VlanId vlanId() {
            return this.vlanId;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.type().toString()).add("id", (Object)this.vlanId).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.vlanId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof VlanIdCriterion) {
                VlanIdCriterion that = (VlanIdCriterion)obj;
                return Objects.equals(this.vlanId, that.vlanId) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class VlanPcpCriterion
    implements Criterion {
        private final Byte vlanPcp;

        public VlanPcpCriterion(Byte vlanPcp) {
            this.vlanPcp = vlanPcp;
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.VLAN_PCP;
        }

        public Byte priority() {
            return this.vlanPcp;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.type().toString()).add("pcp", (Object)Long.toHexString(this.vlanPcp.byteValue())).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.vlanPcp});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof VlanPcpCriterion) {
                VlanPcpCriterion that = (VlanPcpCriterion)obj;
                return Objects.equals(this.vlanPcp, that.vlanPcp) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class IPProtocolCriterion
    implements Criterion {
        private final Byte proto;

        public IPProtocolCriterion(Byte protocol) {
            this.proto = protocol;
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.IP_PROTO;
        }

        public Byte protocol() {
            return this.proto;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.type().toString()).add("protocol", (Object)Long.toHexString(this.proto.byteValue())).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.proto});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IPProtocolCriterion) {
                IPProtocolCriterion that = (IPProtocolCriterion)obj;
                return Objects.equals(this.proto, that.proto);
            }
            return false;
        }
    }

    public static final class IPCriterion
    implements Criterion {
        private final IpPrefix ip;
        private final Criterion.Type type;

        public IPCriterion(IpPrefix ip, Criterion.Type type) {
            this.ip = ip;
            this.type = type;
        }

        @Override
        public Criterion.Type type() {
            return this.type;
        }

        public IpPrefix ip() {
            return this.ip;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.type().toString()).add("ip", (Object)this.ip).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.ip});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IPCriterion) {
                IPCriterion that = (IPCriterion)obj;
                return Objects.equals(this.ip, that.ip) && Objects.equals((Object)this.type, (Object)that.type);
            }
            return false;
        }
    }

    public static final class EthTypeCriterion
    implements Criterion {
        private final Short ethType;

        public EthTypeCriterion(Short ethType) {
            this.ethType = ethType;
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.ETH_TYPE;
        }

        public Short ethType() {
            return this.ethType;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.type().toString()).add("ethType", (Object)Long.toHexString(this.ethType.shortValue())).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.ethType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EthTypeCriterion) {
                EthTypeCriterion that = (EthTypeCriterion)obj;
                return Objects.equals(this.ethType, that.ethType) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class EthCriterion
    implements Criterion {
        private final MacAddress mac;
        private final Criterion.Type type;

        public EthCriterion(MacAddress mac, Criterion.Type type) {
            this.mac = mac;
            this.type = type;
        }

        @Override
        public Criterion.Type type() {
            return this.type;
        }

        public MacAddress mac() {
            return this.mac;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.type().toString()).add("mac", (Object)this.mac).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.mac});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EthCriterion) {
                EthCriterion that = (EthCriterion)obj;
                return Objects.equals(this.mac, that.mac) && Objects.equals((Object)this.type, (Object)that.type);
            }
            return false;
        }
    }

    public static final class PortCriterion
    implements Criterion {
        private final PortNumber port;

        public PortCriterion(PortNumber port) {
            this.port = port;
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.IN_PORT;
        }

        public PortNumber port() {
            return this.port;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.type().toString()).add("port", (Object)this.port).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.port});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PortCriterion) {
                PortCriterion that = (PortCriterion)obj;
                return Objects.equals(this.port, that.port) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }
}

