/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.L0ModificationInstruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;

public final class Instructions {
    private Instructions() {
    }

    public static OutputInstruction createOutput(PortNumber number) {
        Preconditions.checkNotNull((Object)number, (Object)"PortNumber cannot be null");
        return new OutputInstruction(number);
    }

    public static DropInstruction createDrop() {
        return new DropInstruction();
    }

    public static L0ModificationInstruction modL0Lambda(short lambda) {
        Preconditions.checkNotNull((Object)lambda, (Object)"L0 lambda cannot be null");
        return new L0ModificationInstruction.ModLambdaInstruction(L0ModificationInstruction.L0SubType.LAMBDA, lambda);
    }

    public static L2ModificationInstruction modL2Src(MacAddress addr) {
        Preconditions.checkNotNull((Object)addr, (Object)"Src l2 address cannot be null");
        return new L2ModificationInstruction.ModEtherInstruction(L2ModificationInstruction.L2SubType.ETH_SRC, addr);
    }

    public static L2ModificationInstruction modL2Dst(MacAddress addr) {
        Preconditions.checkNotNull((Object)addr, (Object)"Dst l2 address cannot be null");
        return new L2ModificationInstruction.ModEtherInstruction(L2ModificationInstruction.L2SubType.ETH_DST, addr);
    }

    public static L2ModificationInstruction modVlanId(VlanId vlanId) {
        Preconditions.checkNotNull((Object)vlanId, (Object)"VLAN id cannot be null");
        return new L2ModificationInstruction.ModVlanIdInstruction(vlanId);
    }

    public static L2ModificationInstruction modVlanPcp(Byte vlanPcp) {
        Preconditions.checkNotNull((Object)vlanPcp, (Object)"VLAN Pcp cannot be null");
        return new L2ModificationInstruction.ModVlanPcpInstruction(vlanPcp);
    }

    public static L2ModificationInstruction modMplsLabel(Integer mplsLabel) {
        Preconditions.checkNotNull((Object)mplsLabel, (Object)"MPLS label cannot be null");
        return new L2ModificationInstruction.ModMplsLabelInstruction(mplsLabel);
    }

    public static L3ModificationInstruction modL3Src(IpAddress addr) {
        Preconditions.checkNotNull((Object)addr, (Object)"Src l3 address cannot be null");
        return new L3ModificationInstruction.ModIPInstruction(L3ModificationInstruction.L3SubType.IP_SRC, addr);
    }

    public static L3ModificationInstruction modL3Dst(IpAddress addr) {
        Preconditions.checkNotNull((Object)addr, (Object)"Dst l3 address cannot be null");
        return new L3ModificationInstruction.ModIPInstruction(L3ModificationInstruction.L3SubType.IP_DST, addr);
    }

    public static Instruction pushMpls() {
        return new L2ModificationInstruction.PushHeaderInstructions(L2ModificationInstruction.L2SubType.MPLS_PUSH, new Ethernet().setEtherType((short)-30649));
    }

    public static Instruction popMpls() {
        return new L2ModificationInstruction.PushHeaderInstructions(L2ModificationInstruction.L2SubType.MPLS_POP, new Ethernet().setEtherType((short)-30649));
    }

    public static final class OutputInstruction
    implements Instruction {
        private final PortNumber port;

        private OutputInstruction(PortNumber port) {
            this.port = port;
        }

        public PortNumber port() {
            return this.port;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.OUTPUT;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.type().toString()).add("port", (Object)this.port).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.port});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OutputInstruction) {
                OutputInstruction that = (OutputInstruction)obj;
                return Objects.equals(this.port, that.port);
            }
            return false;
        }
    }

    public static final class DropInstruction
    implements Instruction {
        @Override
        public Instruction.Type type() {
            return Instruction.Type.DROP;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)((Object)this.type())).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type()});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof DropInstruction) {
                DropInstruction that = (DropInstruction)obj;
                return Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }
}

