/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.flow.instructions.Instruction;

public abstract class L2ModificationInstruction
implements Instruction {
    public abstract L2SubType subtype();

    @Override
    public Instruction.Type type() {
        return Instruction.Type.L2MODIFICATION;
    }

    public static final class ModMplsLabelInstruction
    extends L2ModificationInstruction {
        private final Integer mplsLabel;

        public ModMplsLabelInstruction(Integer mplsLabel) {
            this.mplsLabel = mplsLabel;
        }

        public Integer label() {
            return this.mplsLabel;
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.MPLS_LABEL;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.type().toString()).add("mpls", this.mplsLabel.intValue()).toString();
        }

        public int hashCode() {
            return Objects.hash(this.mplsLabel);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModMplsLabelInstruction) {
                ModMplsLabelInstruction that = (ModMplsLabelInstruction)obj;
                return Objects.equals(this.mplsLabel, that.mplsLabel) && Objects.equals((Object)this.type(), (Object)that.type());
            }
            return false;
        }
    }

    public static final class ModVlanPcpInstruction
    extends L2ModificationInstruction {
        private final Byte vlanPcp;

        public ModVlanPcpInstruction(Byte vlanPcp) {
            this.vlanPcp = vlanPcp;
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.VLAN_PCP;
        }

        public Byte vlanPcp() {
            return this.vlanPcp;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).add("pcp", (Object)Long.toHexString(this.vlanPcp.byteValue())).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.vlanPcp});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModVlanPcpInstruction) {
                ModVlanPcpInstruction that = (ModVlanPcpInstruction)obj;
                return Objects.equals(this.vlanPcp, that.vlanPcp) && Objects.equals((Object)this.type(), (Object)that.type()) && Objects.equals((Object)this.subtype(), (Object)that.subtype());
            }
            return false;
        }
    }

    public static final class ModVlanIdInstruction
    extends L2ModificationInstruction {
        private final VlanId vlanId;

        public ModVlanIdInstruction(VlanId vlanId) {
            this.vlanId = vlanId;
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.VLAN_ID;
        }

        public VlanId vlanId() {
            return this.vlanId;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).add("id", (Object)this.vlanId).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.vlanId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModVlanIdInstruction) {
                ModVlanIdInstruction that = (ModVlanIdInstruction)obj;
                return Objects.equals(this.vlanId, that.vlanId) && Objects.equals((Object)this.type(), (Object)that.type()) && Objects.equals((Object)this.subtype(), (Object)that.subtype());
            }
            return false;
        }
    }

    public static final class PushHeaderInstructions
    extends L2ModificationInstruction {
        private final L2SubType subtype;
        private final Ethernet ethernetType;

        public PushHeaderInstructions(L2SubType subType, Ethernet ethernetType) {
            this.subtype = subType;
            this.ethernetType = ethernetType;
        }

        public Ethernet ethernetType() {
            return this.ethernetType;
        }

        @Override
        public L2SubType subtype() {
            return this.subtype;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PushHeaderInstructions) {
                PushHeaderInstructions that = (PushHeaderInstructions)obj;
                return Objects.equals((Object)this.type(), (Object)that.type()) && Objects.equals((Object)this.subtype, (Object)that.subtype);
            }
            return false;
        }
    }

    public static final class ModEtherInstruction
    extends L2ModificationInstruction {
        private final L2SubType subtype;
        private final MacAddress mac;

        public ModEtherInstruction(L2SubType subType, MacAddress addr) {
            this.subtype = subType;
            this.mac = addr;
        }

        @Override
        public L2SubType subtype() {
            return this.subtype;
        }

        public MacAddress mac() {
            return this.mac;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).add("mac", (Object)this.mac).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype, this.mac});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModEtherInstruction) {
                ModEtherInstruction that = (ModEtherInstruction)obj;
                return Objects.equals(this.mac, that.mac) && Objects.equals((Object)this.type(), (Object)that.type()) && Objects.equals((Object)this.subtype, (Object)that.subtype);
            }
            return false;
        }
    }

    public static enum L2SubType {
        ETH_SRC,
        ETH_DST,
        VLAN_ID,
        VLAN_PCP,
        MPLS_LABEL,
        MPLS_PUSH,
        MPLS_POP;

    }
}

