/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onosproject.net.flow.instructions.Instruction;

public abstract class L3ModificationInstruction
implements Instruction {
    public abstract L3SubType subtype();

    @Override
    public Instruction.Type type() {
        return Instruction.Type.L3MODIFICATION;
    }

    public static final class ModIPInstruction
    extends L3ModificationInstruction {
        private final L3SubType subtype;
        private final IpAddress ip;

        public ModIPInstruction(L3SubType subType, IpAddress addr) {
            this.subtype = subType;
            this.ip = addr;
        }

        @Override
        public L3SubType subtype() {
            return this.subtype;
        }

        public IpAddress ip() {
            return this.ip;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).add("ip", (Object)this.ip).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.ip});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModIPInstruction) {
                ModIPInstruction that = (ModIPInstruction)obj;
                return Objects.equals(this.ip, that.ip) && Objects.equals((Object)this.type(), (Object)that.type()) && Objects.equals((Object)this.subtype(), (Object)that.subtype());
            }
            return false;
        }
    }

    public static enum L3SubType {
        IP_SRC,
        IP_DST;

    }
}

