/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.host;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;

public class InterfaceIpAddress {
    private final IpAddress ipAddress;
    private final IpPrefix subnetAddress;
    private final IpAddress broadcastAddress;
    private final IpAddress peerAddress;

    public InterfaceIpAddress(InterfaceIpAddress other) {
        this.ipAddress = other.ipAddress;
        this.subnetAddress = other.subnetAddress;
        this.broadcastAddress = other.broadcastAddress;
        this.peerAddress = other.peerAddress;
    }

    public InterfaceIpAddress(IpAddress ipAddress, IpPrefix subnetAddress) {
        this.ipAddress = (IpAddress)Preconditions.checkNotNull((Object)ipAddress);
        this.subnetAddress = (IpPrefix)Preconditions.checkNotNull((Object)subnetAddress);
        this.broadcastAddress = null;
        this.peerAddress = null;
    }

    public InterfaceIpAddress(IpAddress ipAddress, IpPrefix subnetAddress, IpAddress broadcastAddress) {
        this.ipAddress = (IpAddress)Preconditions.checkNotNull((Object)ipAddress);
        this.subnetAddress = (IpPrefix)Preconditions.checkNotNull((Object)subnetAddress);
        this.broadcastAddress = broadcastAddress;
        this.peerAddress = null;
    }

    public InterfaceIpAddress(IpAddress ipAddress, IpPrefix subnetAddress, IpAddress broadcastAddress, IpAddress peerAddress) {
        this.ipAddress = (IpAddress)Preconditions.checkNotNull((Object)ipAddress);
        this.subnetAddress = (IpPrefix)Preconditions.checkNotNull((Object)subnetAddress);
        this.broadcastAddress = broadcastAddress;
        this.peerAddress = peerAddress;
    }

    public IpAddress ipAddress() {
        return this.ipAddress;
    }

    public IpPrefix subnetAddress() {
        return this.subnetAddress;
    }

    public IpAddress broadcastAddress() {
        return this.broadcastAddress;
    }

    public IpAddress peerAddress() {
        return this.peerAddress;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof InterfaceIpAddress)) {
            return false;
        }
        InterfaceIpAddress otherAddr = (InterfaceIpAddress)other;
        return Objects.equals(this.ipAddress, otherAddr.ipAddress) && Objects.equals(this.subnetAddress, otherAddr.subnetAddress) && Objects.equals(this.broadcastAddress, otherAddr.broadcastAddress) && Objects.equals(this.peerAddress, otherAddr.peerAddress);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.subnetAddress, this.broadcastAddress, this.peerAddress);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ipAddress", (Object)this.ipAddress).add("subnetAddress", (Object)this.subnetAddress).add("broadcastAddress", (Object)this.broadcastAddress).add("peerAddress", (Object)this.peerAddress).omitNullValues().toString();
    }
}

