/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.IntentState;

public final class BatchWrite {
    List<Operation> operations = new ArrayList<Operation>();

    private BatchWrite() {
    }

    public static BatchWrite newInstance() {
        return new BatchWrite();
    }

    public List<Operation> operations() {
        return Collections.unmodifiableList(this.operations);
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public BatchWrite createIntent(Intent intent) {
        this.operations.add(Operation.of(OpType.CREATE_INTENT, (List<Object>)ImmutableList.of((Object)intent)));
        return this;
    }

    public BatchWrite removeIntent(IntentId intentId) {
        this.operations.add(Operation.of(OpType.REMOVE_INTENT, (List<Object>)ImmutableList.of((Object)intentId)));
        return this;
    }

    public BatchWrite setState(Intent intent, IntentState newState) {
        this.operations.add(Operation.of(OpType.SET_STATE, (List<Object>)ImmutableList.of((Object)intent, (Object)((Object)newState))));
        return this;
    }

    public BatchWrite setInstallableIntents(IntentId intentId, List<Intent> installableIntents) {
        this.operations.add(Operation.of(OpType.SET_INSTALLABLE, (List<Object>)ImmutableList.of((Object)intentId, installableIntents)));
        return this;
    }

    public BatchWrite removeInstalledIntents(IntentId intentId) {
        this.operations.add(Operation.of(OpType.REMOVE_INSTALLED, (List<Object>)ImmutableList.of((Object)intentId)));
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("operations", this.operations).toString();
    }

    public static class Operation {
        final OpType type;
        final ImmutableList<Object> args;

        public static Operation of(OpType type, List<Object> args) {
            return new Operation(type, args);
        }

        public Operation(OpType type, List<Object> args) {
            this.type = (OpType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
            this.args = ImmutableList.copyOf(args);
        }

        public OpType type() {
            return this.type;
        }

        public ImmutableList<Object> args() {
            return this.args;
        }

        public <T> T arg(int i) {
            return (T)this.args.get(i);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("type", (Object)this.type).add("args", this.args).toString();
        }
    }

    public static enum OpType {
        CREATE_INTENT,
        REMOVE_INTENT,
        SET_STATE,
        SET_INSTALLABLE,
        REMOVE_INSTALLED;

    }
}

