/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.IdGenerator;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.flow.BatchOperationTarget;
import org.onosproject.net.intent.IntentId;

public abstract class Intent
implements BatchOperationTarget {
    private final IntentId id;
    private final ApplicationId appId;
    private final Collection<NetworkResource> resources;
    private static IdGenerator idGenerator;

    protected Intent() {
        this.id = null;
        this.appId = null;
        this.resources = null;
    }

    protected Intent(ApplicationId appId, Collection<NetworkResource> resources) {
        Preconditions.checkState((idGenerator != null ? 1 : 0) != 0, (Object)"Id generator is not bound.");
        this.id = IntentId.valueOf(idGenerator.getNewId());
        this.appId = (ApplicationId)Preconditions.checkNotNull((Object)appId, (Object)"Application ID cannot be null");
        this.resources = resources;
    }

    public IntentId id() {
        return this.id;
    }

    public ApplicationId appId() {
        return this.appId;
    }

    public Collection<NetworkResource> resources() {
        return this.resources;
    }

    public boolean isInstallable() {
        return false;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Intent other = (Intent)obj;
        return this.id().equals(other.id());
    }

    public static void bindIdGenerator(IdGenerator newIdGenerator) {
        Preconditions.checkState((idGenerator == null ? 1 : 0) != 0, (Object)"Id generator is already bound.");
        idGenerator = (IdGenerator)Preconditions.checkNotNull((Object)newIdGenerator);
    }

    public static void unbindIdGenerator(IdGenerator oldIdGenerator) {
        if (Objects.equals(idGenerator, oldIdGenerator)) {
            idGenerator = null;
        }
    }
}

