/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;

public final class MultiPointToSinglePointIntent
extends ConnectivityIntent {
    private final Set<ConnectPoint> ingressPoints;
    private final ConnectPoint egressPoint;

    public MultiPointToSinglePointIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, Set<ConnectPoint> ingressPoints, ConnectPoint egressPoint) {
        this(appId, selector, treatment, ingressPoints, egressPoint, Collections.emptyList());
    }

    public MultiPointToSinglePointIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, Set<ConnectPoint> ingressPoints, ConnectPoint egressPoint, List<Constraint> constraints) {
        super(appId, null, selector, treatment, constraints);
        Preconditions.checkNotNull(ingressPoints);
        Preconditions.checkArgument((!ingressPoints.isEmpty() ? 1 : 0) != 0, (Object)"Ingress point set cannot be empty");
        Preconditions.checkNotNull((Object)egressPoint);
        Preconditions.checkArgument((!ingressPoints.contains(egressPoint) ? 1 : 0) != 0, (String)"Set of ingresses should not contain egress (egress: %s)", (Object[])new Object[]{egressPoint});
        this.ingressPoints = Sets.newHashSet(ingressPoints);
        this.egressPoint = egressPoint;
    }

    protected MultiPointToSinglePointIntent() {
        this.ingressPoints = null;
        this.egressPoint = null;
    }

    public Set<ConnectPoint> ingressPoints() {
        return this.ingressPoints;
    }

    public ConnectPoint egressPoint() {
        return this.egressPoint;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("appId", (Object)this.appId()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("ingress", this.ingressPoints()).add("egress", (Object)this.egressPoint()).add("constraints", this.constraints()).toString();
    }
}

