/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.Path;
import org.onosproject.net.intent.Intent;

public class OpticalPathIntent
extends Intent {
    private final ConnectPoint src;
    private final ConnectPoint dst;
    private final Path path;

    public OpticalPathIntent(ApplicationId appId, ConnectPoint src, ConnectPoint dst, Path path) {
        super(appId, (Collection<NetworkResource>)ImmutableSet.copyOf(path.links()));
        this.src = src;
        this.dst = dst;
        this.path = path;
    }

    protected OpticalPathIntent() {
        this.src = null;
        this.dst = null;
        this.path = null;
    }

    public ConnectPoint src() {
        return this.src;
    }

    public ConnectPoint dst() {
        return this.dst;
    }

    public Path path() {
        return this.path;
    }

    @Override
    public boolean isInstallable() {
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("ingressPort", (Object)this.src).add("egressPort", (Object)this.dst).add("path", (Object)this.path).toString();
    }

    public Collection<Link> requiredLinks() {
        return this.path.links();
    }
}

