/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;

public class PathIntent
extends ConnectivityIntent {
    private final Path path;

    public PathIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, Path path) {
        this(appId, selector, treatment, path, Collections.emptyList());
    }

    public PathIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, Path path, List<Constraint> constraints) {
        super(appId, PathIntent.resources(path.links()), selector, treatment, constraints);
        PathIntent.validate(path.links());
        this.path = path;
    }

    protected PathIntent() {
        this.path = null;
    }

    public static void validate(List<Link> links) {
        Preconditions.checkArgument((boolean)Iterables.all(links, (Predicate)new Predicate<Link>(){

            public boolean apply(Link link) {
                return !link.src().elementId().equals(link.dst().elementId());
            }
        }), (String)"element of src and dst in a link must be different: {}", (Object[])new Object[]{links});
        boolean adjacentSame = true;
        for (int i = 0; i < links.size() - 1; ++i) {
            if (links.get(i).dst().elementId().equals(links.get(i + 1).src().elementId())) continue;
            adjacentSame = false;
            break;
        }
        Preconditions.checkArgument((boolean)adjacentSame, (String)"adjacent links must share the same element: {}", (Object[])new Object[]{links});
    }

    public Path path() {
        return this.path;
    }

    @Override
    public boolean isInstallable() {
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("appId", (Object)this.appId()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("constraints", this.constraints()).add("path", (Object)this.path).toString();
    }
}

